/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import junit.framework.TestCase;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationContextTestSupport
extends TestCase {
    protected AbstractXmlApplicationContext applicationContext;

    protected abstract ClassPathXmlApplicationContext createApplicationContext();

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        ApplicationContextTestSupport.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        ApplicationContextTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        ApplicationContextTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className(value)));
        return null;
    }
}

