/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryType;
import org.apache.camel.util.jndi.JndiContext;

public class RoutingSlipWithExceptionTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "routingSlipHeader";
    protected MyBean myBean = new MyBean();
    private MockEndpoint endEndpoint;
    private MockEndpoint exceptionEndpoint;
    private MockEndpoint exceptionSettingEndpoint;

    public void testNoException() throws Exception {
        this.endEndpoint.expectedMessageCount(1);
        this.exceptionEndpoint.expectedMessageCount(0);
        this.sendRoutingSlipWithNoExceptionThrowingComponent();
        this.assertEndpointsSatisfied();
    }

    public void testWithExceptionThrowingComponentFirstInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionThrowingComponentFirstInList();
        this.assertEndpointsSatisfied();
    }

    public void testWithExceptionThrowingComponentSecondInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionThrowingComponentSecondInList();
        this.assertEndpointsSatisfied();
    }

    public void testWithExceptionSettingComponentFirstInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionSettingComponentFirstInList();
        this.assertEndpointsSatisfied();
    }

    public void testWithExceptionSettingComponentSecondInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionSettingComponentSecondInList();
        this.assertEndpointsSatisfied();
    }

    private void assertEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied(5L, TimeUnit.SECONDS, this.endEndpoint, this.exceptionEndpoint);
    }

    protected void sendRoutingSlipWithExceptionThrowingComponentFirstInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"myBean?method=throwException,mock:x");
    }

    protected void sendRoutingSlipWithExceptionThrowingComponentSecondInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a,myBean?method=throwException");
    }

    protected void sendRoutingSlipWithNoExceptionThrowingComponent() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a");
    }

    protected void sendRoutingSlipWithExceptionSettingComponentFirstInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:exceptionSetting,mock:a");
    }

    protected void sendRoutingSlipWithExceptionSettingComponentSecondInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a,mock:exceptionSetting");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.endEndpoint = this.resolveMandatoryEndpoint("mock:noexception", MockEndpoint.class);
        this.exceptionEndpoint = this.resolveMandatoryEndpoint("mock:exception", MockEndpoint.class);
        this.exceptionSettingEndpoint = this.resolveMandatoryEndpoint("mock:exceptionSetting", MockEndpoint.class);
        this.exceptionSettingEndpoint.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException(new Exception("Throw me!"));
            }
        });
        Object lookedUpBean = this.context.getRegistry().lookup("myBean");
        RoutingSlipWithExceptionTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryType)((TryType)this.from("direct:start").tryBlock().routingSlip()).to("mock:noexception")).handle(Exception.class).to("mock:exception");
            }
        };
    }

    public static class MyBean {
        public void throwException() throws Exception {
            throw new Exception("Throw me!");
        }
    }
}

