/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RedeliveryPolicyPerExceptionTest
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;

    public void testUsingCustomExceptionHandlerAndOneRedelivery() throws Exception {
        this.a.expectedMessageCount(1);
        this.sendBody("direct:start", "a");
        MockEndpoint.assertIsSatisfied(this.a, this.b);
        List<Exchange> list = this.a.getReceivedExchanges();
        RedeliveryPolicyPerExceptionTest.assertTrue((String)"List should not be empty!", (!list.isEmpty() ? 1 : 0) != 0);
        Exchange exchange = list.get(0);
        Message in = exchange.getIn();
        this.log.info((Object)("Found message with headers: " + in.getHeaders()));
        this.assertMessageHeader(in, "org.apache.camel.RedeliveryCounter", 2);
        this.assertMessageHeader(in, "org.apache.camel.Redelivered", true);
    }

    public void testUsingCustomExceptionHandlerWithNoRedeliveries() throws Exception {
        this.b.expectedMessageCount(1);
        this.sendBody("direct:start", "b");
        MockEndpoint.assertIsSatisfied(this.a, this.b);
        List<Exchange> list = this.b.getReceivedExchanges();
        RedeliveryPolicyPerExceptionTest.assertTrue((String)"List should not be empty!", (!list.isEmpty() ? 1 : 0) != 0);
        Exchange exchange = list.get(0);
        Message in = exchange.getIn();
        this.log.info((Object)("Found message with headers: " + in.getHeaders()));
        this.assertMessageHeader(in, "org.apache.camel.RedeliveryCounter", 1);
        this.assertMessageHeader(in, "org.apache.camel.Redelivered", true);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        this.b = this.resolveMandatoryEndpoint("mock:b", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                if ("b".equals(exchange.getIn().getBody())) {
                    throw new NullPointerException("MyCustomException");
                }
                throw new IllegalArgumentException("MyCustomException");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.exception(IllegalArgumentException.class).maximumRedeliveries(2).to("mock:a");
                this.exception(NullPointerException.class).to("mock:b");
                this.from("direct:start").process(processor);
            }
        };
    }
}

