/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceType;

public class InterceptRouteTest
extends ContextTestSupport {
    private MockEndpoint a;
    private MockEndpoint b;

    public void testSendMatchingMessage() throws Exception {
        this.b.expectedMessageCount(1);
        this.a.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisifed();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.assertMockEndpointsSatisifed();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceType)this.intercept().choice().when(this.header("foo").isEqualTo("bar")).to("mock:b")).otherwise().proceed();
                this.from("direct:start").to("mock:a");
            }
        };
    }
}

