/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class FaultRouteTest
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;
    protected MockEndpoint c;
    protected boolean shouldWork = true;

    public void testWithOut() throws Exception {
        this.a.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setBody("out");
            }
        });
        this.a.expectedMessageCount(1);
        this.b.expectedBodiesReceived("out");
        this.c.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"in");
        MockEndpoint.assertIsSatisfied(this.a, this.b, this.c);
    }

    public void testWithFault() throws Exception {
        this.shouldWork = false;
        this.a.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getFault().setBody("fault");
            }
        });
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(0);
        this.c.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"in");
        MockEndpoint.assertIsSatisfied(this.a, this.b, this.c);
        List<Exchange> list = this.a.getReceivedExchanges();
        Exchange exchange = list.get(0);
        Message fault = exchange.getFault();
        FaultRouteTest.assertNotNull((String)"Should have a fault on A", (Object)fault);
        FaultRouteTest.assertEquals((String)"Fault body", (Object)"fault", (Object)fault.getBody());
    }

    public void testWithThrowFaultMessage() throws Exception {
        this.throwFaultTest("direct:string");
    }

    public void testWithThrowFaultException() throws Exception {
        this.throwFaultTest("direct:exception");
    }

    private void throwFaultTest(String startPoint) throws InterruptedException {
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(0);
        this.c.expectedMessageCount(0);
        this.template.sendBody(startPoint, (Object)"in");
        MockEndpoint.assertIsSatisfied(this.a, this.b, this.c);
        List<Exchange> list = this.a.getReceivedExchanges();
        Exchange exchange = list.get(0);
        Message fault = exchange.getFault();
        FaultRouteTest.assertNotNull((String)"Should have a fault on A", (Object)fault);
        if (startPoint.equals("direct:exception")) {
            FaultRouteTest.assertTrue((String)"It should be the IllegalStateException", (boolean)(fault.getBody() instanceof IllegalStateException));
            FaultRouteTest.assertEquals((String)"Fault message", (String)"It makes no sense of business logic", (String)((IllegalStateException)fault.getBody()).getMessage());
        } else {
            FaultRouteTest.assertTrue((String)"It should be the CamelException", (boolean)(fault.getBody() instanceof CamelException));
            FaultRouteTest.assertEquals((String)"Fault message", (String)"ExceptionMessage", (String)((CamelException)fault.getBody()).getMessage());
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        this.b = this.resolveMandatoryEndpoint("mock:b", MockEndpoint.class);
        this.c = this.resolveMandatoryEndpoint("mock:c", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:start").to("mock:a")).to("mock:b");
                ((ProcessorType)((ProcessorType)this.from("direct:string").to("mock:a")).throwFault("ExceptionMessage")).to("mock:b");
                ((ProcessorType)((ProcessorType)this.from("direct:exception").to("mock:a")).throwFault(new IllegalStateException("It makes no sense of business logic"))).to("mock:b");
            }
        };
    }
}

