/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceType;

public class ChoiceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    public void testSendToFirstWhen() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.y, this.z);
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisifed();
    }

    public void testSendToSecondWhen() throws Exception {
        String body = "<two/>";
        this.y.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.x, this.z);
        this.sendMessage("cheese", body);
        this.assertMockEndpointsSatisifed();
    }

    public void testSendToOtherwiseClause() throws Exception {
        String body = "<three/>";
        this.z.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.x, this.y);
        this.sendMessage("somethingUndefined", body);
        this.assertMockEndpointsSatisifed();
    }

    protected void sendMessage(Object headerValue, Object body) throws Exception {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)((ChoiceType)this.from("direct:start").choice().when(this.header("foo").isEqualTo("bar")).setHeader("name", this.constant("a"))).to("mock:x")).when(this.header("foo").isEqualTo("cheese")).to("mock:y")).otherwise().to("mock:z");
            }
        };
    }
}

