/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceProcessor
extends ServiceSupport
implements Processor {
    private List<FilterProcessor> filters = new ArrayList<FilterProcessor>();
    private Processor otherwise;

    public ChoiceProcessor(List<FilterProcessor> filters, Processor otherwise) {
        this.filters = filters;
        this.otherwise = otherwise;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        for (FilterProcessor filterProcessor : this.filters) {
            Predicate<Exchange> predicate = filterProcessor.getPredicate();
            if (predicate == null || !predicate.matches(exchange)) continue;
            filterProcessor.getProcessor().process(exchange);
            return;
        }
        if (this.otherwise != null) {
            this.otherwise.process(exchange);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("choice{");
        boolean first = true;
        for (FilterProcessor processor : this.filters) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("when ");
            builder.append(processor.getPredicate().toString());
            builder.append(": ");
            builder.append(processor.getProcessor());
        }
        if (this.otherwise != null) {
            builder.append(", otherwise: ");
            builder.append(this.otherwise);
        }
        builder.append("}");
        return builder.toString();
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.filters);
        ServiceHelper.startServices(this.otherwise);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.otherwise);
        ServiceHelper.stopServices(this.filters);
    }
}

