/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.InstrumentationAgentImpl;

public class JmxInstrumentationUsingDefaultsTest
extends ContextTestSupport {
    public static final int DEFAULT_PORT = 1099;
    protected InstrumentationAgentImpl iAgent;
    protected String domainName = "org.apache.camel";
    protected boolean sleepSoYouCanBrowseInJConsole;

    public void testMBeansRegistered() throws Exception {
        JmxInstrumentationUsingDefaultsTest.assertNotNull((Object)this.iAgent.getMBeanServer());
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        ObjectName name = new ObjectName(this.domainName + ":group=endpoints,*");
        Set<ObjectName> s = this.iAgent.getMBeanServer().queryNames(name, null);
        if (this.sleepSoYouCanBrowseInJConsole) {
            Thread.sleep(100000L);
        }
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Could not find 2 endpoints: " + s), (int)2, (int)s.size());
    }

    public void testCounters() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived("<hello>world!</hello>");
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        MBeanServer mbs = this.iAgent.getMBeanServer();
        ObjectName name = new ObjectName(this.domainName + ":type=Stats,*");
        Set<ObjectName> s = mbs.queryNames(name, null);
        JmxInstrumentationUsingDefaultsTest.assertEquals((String)("Found mbeans: " + s), (int)1, (int)s.size());
        Iterator<ObjectName> iter = s.iterator();
        ObjectName pcob = iter.next();
        Long valueofNumExchanges = (Long)mbs.getAttribute(pcob, "NumExchanges");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumExchanges);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofNumExchanges == 1L ? 1 : 0) != 0);
        Long valueofNumCompleted = (Long)mbs.getAttribute(pcob, "NumCompleted");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumCompleted);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofNumCompleted == 1L ? 1 : 0) != 0);
        Long valueofNumFailed = (Long)mbs.getAttribute(pcob, "NumFailed");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofNumFailed);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofNumFailed == 0L ? 1 : 0) != 0);
        Long valueofMinProcessingTime = (Long)mbs.getAttribute(pcob, "MinProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMinProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMinProcessingTime > 0L ? 1 : 0) != 0);
        Long valueofMaxProcessingTime = (Long)mbs.getAttribute(pcob, "MaxProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMaxProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMaxProcessingTime > 0L ? 1 : 0) != 0);
        Long valueofMeanProcessingTime = (Long)mbs.getAttribute(pcob, "MeanProcessingTime");
        JmxInstrumentationUsingDefaultsTest.assertNotNull((String)"Expected attribute not found. MBean registerred under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class", (Object)valueofMeanProcessingTime);
        JmxInstrumentationUsingDefaultsTest.assertTrue((valueofMeanProcessingTime >= valueofMinProcessingTime && valueofMeanProcessingTime <= valueofMaxProcessingTime ? 1 : 0) != 0);
    }

    protected void enableJmx() {
        this.iAgent.enableJmx(null, 0);
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.createInstrumentationAgent(context, 1099);
        return context;
    }

    protected void createInstrumentationAgent(CamelContext context, int port) throws Exception {
        this.iAgent = new InstrumentationAgentImpl();
        this.iAgent.setCamelContext(context);
        this.enableJmx();
        this.iAgent.start();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:end");
            }
        };
    }

    protected void tearDown() throws Exception {
        this.iAgent.stop();
        super.tearDown();
    }
}

