/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.camel.converter.IOConverter;

public class IOConverterTest
extends TestCase {
    private static final byte[] TESTDATA = "My test data".getBytes();

    public void testToBytes() throws FileNotFoundException, IOException {
        int fileSize = 962;
        byte[] data = IOConverter.toBytes(new FileInputStream("src/test/resources/org/apache/camel/converter/dummy.txt"));
        if (System.getProperty("os.name").startsWith("Windows")) {
            fileSize = 979;
        }
        IOConverterTest.assertEquals((String)"get the wrong byte size", (int)fileSize, (int)data.length);
        IOConverterTest.assertEquals((char)'#', (char)((char)data[0]));
        IOConverterTest.assertEquals((char)'!', (char)((char)data[data.length - 1]));
    }

    public void testCopy() throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(TESTDATA);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOConverter.copy(bis, bos);
        this.assertEquals(TESTDATA, bos.toByteArray());
    }

    private void assertEquals(byte[] data1, byte[] data2) {
        IOConverterTest.assertEquals((int)data1.length, (int)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            IOConverterTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
    }
}

