/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.ServiceHelper;

public class VmRouteTest
extends TestSupport {
    private CamelContext context1 = new DefaultCamelContext();
    private CamelContext context2 = new DefaultCamelContext();
    private CamelTemplate template = new CamelTemplate(this.context1);
    private Object expectedBody = "<hello>world!</hello>";

    public void testSedaQueue() throws Exception {
        MockEndpoint result = this.context2.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(this.expectedBody);
        this.template.sendBody("vm:test.a", this.expectedBody);
        result.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context1.addRoutes(new RouteBuilder(){

            public void configure() {
                this.from("vm:test.a").to("vm:test.b");
            }
        });
        this.context2.addRoutes(new RouteBuilder(){

            public void configure() {
                this.from("vm:test.b").to("mock:result");
            }
        });
        ServiceHelper.startServices(this.context1, this.context2);
    }

    protected void tearDown() throws Exception {
        ServiceHelper.stopServices(this.context2, this.context1);
        super.tearDown();
    }
}

