/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerRouteTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(TimerRouteTest.class);
    private MyBean bean = new MyBean();

    public void testTimerInvokesBeanMethod() throws Exception {
        Thread.sleep(2000L);
        TimerRouteTest.assertTrue((String)"", (this.bean.counter.get() >= 2 ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://foo?fixedRate=true&delay=0&period=500").to("bean:myBean");
            }
        };
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    public static class MyBean {
        public AtomicInteger counter = new AtomicInteger(0);

        public void someMethod() {
            LOG.debug((Object)"Invoked someMethod()");
            this.counter.incrementAndGet();
        }
    }
}

