/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.cxf.message.Message;

public class CxfBinding {
    public static Object extractBodyFromCxf(CxfExchange exchange, Message message) {
        return CxfBinding.getBody(message);
    }

    protected static Object getBody(Message message) {
        Set contentFormats = message.getContentFormats();
        if (contentFormats != null) {
            for (Class contentFormat : contentFormats) {
                Object answer = message.getContent(contentFormat);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public Message createCxfMessage(CxfExchange exchange) {
        Message answer = exchange.getInMessage();
        CxfMessage in = exchange.getIn();
        Object body = in.getBody(InputStream.class);
        if (body == null) {
            body = in.getBody();
        }
        if (body instanceof InputStream) {
            answer.setContent(InputStream.class, body);
        } else if (body instanceof List) {
            answer.setContent(List.class, body);
            answer.put((Object)"operationName", (Object)((String)in.getHeader("operationName")));
            answer.put((Object)"operationNameSpace", (Object)((String)in.getHeader("operationNameSpace")));
        }
        return answer;
    }

    public void storeCxfResponse(CxfExchange exchange, Message response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            out.setMessage(response);
            out.setBody(response.getContent(InputStream.class));
        }
    }

    public void storeCxfResponse(CxfExchange exchange, Object response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            out.setBody(response);
        }
    }

    public void storeCxfFault(CxfExchange exchange, Message message) {
        CxfMessage fault = exchange.getFault();
        if (fault != null) {
            fault.setBody(CxfBinding.getBody(message));
        }
    }
}

