/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.List;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.EntryFilter;
import org.apache.camel.component.atom.UpdatedDateFilter;
import org.apache.camel.impl.PollingConsumerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEntryPollingConsumer
extends PollingConsumerSupport {
    private final AtomEndpoint endpoint;
    private Document<Feed> document;
    private int entryIndex;
    private EntryFilter entryFilter = new UpdatedDateFilter();
    private List<Entry> list;

    public AtomEntryPollingConsumer(AtomEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public Exchange receiveNoWait() {
        try {
            this.getDocument();
            while (this.hasNextEntry()) {
                Entry entry;
                if (!this.entryFilter.isValidEntry(this.endpoint, this.document, entry = this.list.get(this.entryIndex--))) continue;
                return this.endpoint.createExchange(this.document, entry);
            }
            this.document = null;
            return null;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public Exchange receive() {
        return this.receiveNoWait();
    }

    @Override
    public Exchange receive(long timeout) {
        return this.receiveNoWait();
    }

    public EntryFilter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(EntryFilter entryFilter) {
        this.entryFilter = entryFilter;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    public Document<Feed> getDocument() throws Exception {
        if (this.document == null) {
            this.document = this.endpoint.parseDocument();
            this.list = ((Feed)this.document.getRoot()).getEntries();
            this.entryIndex = this.list.size() - 1;
        }
        return this.document;
    }

    protected boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

