/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.net.URL;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class XsltTest
extends ContextTestSupport {
    public void testXslt() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived("<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>");
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                URL styleSheet = this.getClass().getResource("example.xsl");
                ((ProcessorType)this.from("direct:start").process(XsltBuilder.xslt(styleSheet))).to("mock:result");
            }
        };
    }
}

