/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.builder.xml.XPathBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathWithNamespacesFromDomTest
extends ContextTestSupport {
    public void testXPathUsingDomForNamespaces() throws Exception {
        Document document = this.context.getTypeConverter().convertTo(Document.class, "<x:foo xmlns:x='n1' xmlns:y='n2'><bar id='a' xmlns:y='n3'/></x:foo>");
        Element element = (Element)document.getElementsByTagName("bar").item(0);
        XPathWithNamespacesFromDomTest.assertNotNull((String)"Could not find element for id 'a'", (Object)element);
        XPathBuilder builder = XPathBuilder.xpath("//y:foo[@id='z']");
        Namespaces ns = new Namespaces(element);
        ns.configure(builder);
        DefaultNamespaceContext namespaceContext = builder.getNamespaceContext();
        XPathWithNamespacesFromDomTest.assertEquals((String)"y namespace", (String)"n3", (String)namespaceContext.getNamespaceURI("y"));
        this.assertPredicateMatches(builder, this.createExchangeWithBody("<blah><foo xmlns='n3' id='z'/></blah>"));
        this.assertPredicateDoesNotMatch(builder, this.createExchangeWithBody("<blah><foo xmlns='n2' id='z'/></blah>"));
    }
}

