/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.model;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.camel.bam.model.ActivityDefinition;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.model.TemporalEntity;
import org.apache.camel.bam.processor.ProcessContext;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.util.ObjectHelper;

@Entity
public class ActivityState
extends TemporalEntity {
    private ProcessInstance processInstance;
    private Integer receivedMessageCount = 0;
    private ActivityDefinition activityDefinition;
    private Date timeExpected;
    @Temporal(value=TemporalType.TIME)
    private Date timeOverdue;
    private Integer escalationLevel = 0;

    @Id
    @GeneratedValue
    public Long getId() {
        return super.getId();
    }

    public String toString() {
        return "ActivityState[" + this.getId() + " on " + this.getProcessInstance() + " " + this.getActivityDefinition() + "]";
    }

    public synchronized void processExchange(ActivityRules activityRules, ProcessContext context) throws Exception {
        int expectedMessages;
        int messageCount = 0;
        Integer count = this.getReceivedMessageCount();
        if (count != null) {
            messageCount = count;
        }
        this.setReceivedMessageCount(++messageCount);
        if (messageCount == 1) {
            this.onFirstMessage(context);
        }
        if (messageCount == (expectedMessages = activityRules.getExpectedMessages())) {
            this.onExpectedMessage(context);
        } else if (messageCount > expectedMessages) {
            this.onExcessMessage(context);
        }
    }

    public boolean isActivity(ActivityRules activityRules) {
        return ObjectHelper.equal(this.getActivityDefinition(), activityRules.getActivityDefinition());
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        processInstance.getActivityStates().add(this);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public ActivityDefinition getActivityDefinition() {
        return this.activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Integer getEscalationLevel() {
        return this.escalationLevel;
    }

    public void setEscalationLevel(Integer escalationLevel) {
        this.escalationLevel = escalationLevel;
    }

    public Integer getReceivedMessageCount() {
        return this.receivedMessageCount;
    }

    public void setReceivedMessageCount(Integer receivedMessageCount) {
        this.receivedMessageCount = receivedMessageCount;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeExpected() {
        return this.timeExpected;
    }

    public void setTimeExpected(Date timeExpected) {
        this.timeExpected = timeExpected;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeOverdue() {
        return this.timeOverdue;
    }

    public void setTimeOverdue(Date timeOverdue) {
        this.timeOverdue = timeOverdue;
    }

    public void setTimeCompleted(Date timeCompleted) {
        super.setTimeCompleted(timeCompleted);
        if (timeCompleted != null) {
            this.setEscalationLevel(-1);
        }
    }

    @Transient
    public String getCorrelationKey() {
        ProcessInstance pi = this.getProcessInstance();
        if (pi == null) {
            return null;
        }
        return pi.getCorrelationKey();
    }

    protected void onFirstMessage(ProcessContext context) {
        if (!this.isStarted()) {
            this.setTimeStarted(this.currentTime());
            context.onStarted(this);
        }
    }

    protected void onExpectedMessage(ProcessContext context) {
        if (!this.isCompleted()) {
            this.setTimeCompleted(this.currentTime());
            context.onCompleted(this);
        }
    }

    protected void onExcessMessage(ProcessContext context) {
    }

    protected Date currentTime() {
        return new Date();
    }
}

