/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendProcessor
extends ServiceSupport
implements AsyncProcessor,
Service {
    private static final transient Log LOG = LogFactory.getLog(SendProcessor.class);
    private Endpoint destination;
    private Producer producer;
    private AsyncProcessor processor;

    public SendProcessor(Endpoint destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Endpoint cannot be null!");
        }
        this.destination = destination;
    }

    public String toString() {
        return "sendTo(" + this.destination + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Exchange exchange) throws Exception {
        if (this.producer == null) {
            if (!this.isStopped()) throw new IllegalStateException("No producer, this processor has not been started!");
            LOG.warn("Ignoring exchange sent after processor is stopped: " + exchange);
            return;
        } else {
            this.producer.process(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.producer == null) {
            if (this.isStopped()) {
                LOG.warn("Ignoring exchange sent after processor is stopped: " + exchange);
            } else {
                exchange.setException(new IllegalStateException("No producer, this processor has not been started!"));
            }
            callback.done(true);
            return true;
        }
        return this.processor.process(exchange, callback);
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    protected void doStart() throws Exception {
        this.producer = this.destination.createProducer();
        this.producer.start();
        this.processor = AsyncProcessorTypeConverter.convert(this.producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this.producer != null) {
            try {
                this.producer.stop();
            }
            finally {
                this.producer = null;
                this.processor = null;
            }
        }
    }
}

