/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DataTypeExpression;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.AggregatorType;
import org.apache.camel.model.BeanRef;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.DelayerType;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.FilterType;
import org.apache.camel.model.IdempotentConsumerType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.MarshalType;
import org.apache.camel.model.MulticastType;
import org.apache.camel.model.NodeFactory;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.PolicyRef;
import org.apache.camel.model.ProceedType;
import org.apache.camel.model.ProcessorRef;
import org.apache.camel.model.RecipientListType;
import org.apache.camel.model.ResequencerType;
import org.apache.camel.model.SplitterType;
import org.apache.camel.model.ThreadType;
import org.apache.camel.model.ThrottlerType;
import org.apache.camel.model.ToType;
import org.apache.camel.model.TryType;
import org.apache.camel.model.UnmarshalType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Policy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessorType<Type extends ProcessorType> {
    public static final String DEFAULT_TRACE_CATEGORY = "org.apache.camel.TRACE";
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Boolean inheritErrorHandlerFlag = Boolean.TRUE;
    private DelegateProcessor lastInterceptor;
    private NodeFactory nodeFactory;

    public abstract List<ProcessorType<?>> getOutputs();

    public abstract List<InterceptorType> getInterceptors();

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet for class: " + this.getClass().getName());
    }

    public Processor createOutputsProcessor(RouteContext routeContext) throws Exception {
        List<ProcessorType<?>> outputs = this.getOutputs();
        return this.createOutputsProcessor(routeContext, outputs);
    }

    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Processor processor = this.makeProcessor(routeContext);
        routeContext.addEventDrivenProcessor(processor);
    }

    public Processor wrapProcessor(RouteContext routeContext, Processor processor) throws Exception {
        processor = this.wrapProcessorInInterceptors(routeContext, processor);
        return this.wrapInErrorHandler(processor);
    }

    public Type to(String uri) {
        this.addOutput(new ToType(uri));
        return (Type)this;
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToType(endpoint));
        return (Type)this;
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToType(uri));
        }
        return (Type)this;
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToType(endpoint));
        }
        return (Type)this;
    }

    public Type to(Collection<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToType(endpoint));
        }
        return (Type)this;
    }

    public MulticastType multicast() {
        MulticastType answer = new MulticastType();
        this.addOutput(answer);
        return answer;
    }

    public Type pipeline(String ... uris) {
        return this.to(uris);
    }

    public Type pipeline(Endpoint ... endpoints) {
        return this.to(endpoints);
    }

    public Type pipeline(Collection<Endpoint> endpoints) {
        return this.to(endpoints);
    }

    public IdempotentConsumerType idempotentConsumer(Expression messageIdExpression, MessageIdRepository messageIdRepository) {
        IdempotentConsumerType answer = new IdempotentConsumerType(messageIdExpression, messageIdRepository);
        this.addOutput(answer);
        return answer;
    }

    public FilterType filter(Predicate predicate) {
        FilterType filter = new FilterType(predicate);
        this.addOutput(filter);
        return filter;
    }

    public ChoiceType choice() {
        ChoiceType answer = new ChoiceType();
        this.addOutput(answer);
        return answer;
    }

    public TryType tryBlock() {
        TryType answer = new TryType();
        this.addOutput(answer);
        return answer;
    }

    public Type recipientList(Expression receipients) {
        RecipientListType answer = new RecipientListType(receipients);
        this.addOutput(answer);
        return (Type)this;
    }

    public SplitterType splitter(Expression receipients) {
        SplitterType answer = new SplitterType(receipients);
        this.addOutput(answer);
        return answer;
    }

    public ResequencerType resequencer(Expression<Exchange> expression) {
        return this.resequencer(Collections.singletonList(expression));
    }

    public ResequencerType resequencer(List<Expression> expressions) {
        ResequencerType answer = new ResequencerType(expressions);
        this.addOutput(answer);
        return answer;
    }

    public ResequencerType resequencer(Expression ... expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            list.add(expression);
        }
        return this.resequencer(list);
    }

    public AggregatorType aggregator(Expression correlationExpression) {
        AggregatorType answer = new AggregatorType(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregatorType aggregator(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregatorType answer = new AggregatorType(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayerType delayer(Expression<Exchange> processAtExpression) {
        return this.delayer(processAtExpression, 0L);
    }

    public DelayerType delayer(Expression<Exchange> processAtExpression, long delay) {
        DelayerType answer = new DelayerType(processAtExpression, delay);
        this.addOutput(answer);
        return answer;
    }

    public DelayerType delayer(long delay) {
        return this.delayer(null, delay);
    }

    public ThrottlerType throttler(long maximumRequestCount) {
        ThrottlerType answer = new ThrottlerType(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public Type interceptor(String ref) {
        this.getInterceptors().add(new InterceptorRef(ref));
        return (Type)this;
    }

    public InterceptType intercept() {
        InterceptType answer = new InterceptType();
        this.addOutput(answer);
        return answer;
    }

    public Type proceed() {
        this.addOutput(new ProceedType());
        return (Type)this;
    }

    public ExceptionType exception(Class exceptionType) {
        ExceptionType answer = new ExceptionType(exceptionType);
        this.addOutput(answer);
        return answer;
    }

    public OtherwiseType intercept(Predicate predicate) {
        InterceptType answer = new InterceptType();
        this.addOutput(answer);
        return answer.when(predicate);
    }

    public Type interceptors(String ... refs) {
        for (String ref : refs) {
            this.interceptor(ref);
        }
        return (Type)this;
    }

    public FilterType filter(ExpressionType expression) {
        FilterType filter = this.getNodeFactory().createFilter();
        filter.setExpression(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterType filter(String language, String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public Type trace() {
        return this.trace(DEFAULT_TRACE_CATEGORY);
    }

    public Type trace(String category) {
        final Log log = LogFactory.getLog(category);
        return this.intercept(new DelegateProcessor(){

            public void process(Exchange exchange) throws Exception {
                log.trace(exchange);
                this.processNext(exchange);
            }
        });
    }

    public PolicyRef policies() {
        PolicyRef answer = new PolicyRef();
        this.addOutput(answer);
        return answer;
    }

    public PolicyRef policy(Policy policy) {
        PolicyRef answer = new PolicyRef(policy);
        this.addOutput(answer);
        return answer;
    }

    public Type intercept(DelegateProcessor interceptor) {
        this.getInterceptors().add(new InterceptorRef(interceptor));
        this.lastInterceptor = interceptor;
        return (Type)this;
    }

    public Type errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return (Type)this;
    }

    public Type inheritErrorHandler(boolean condition) {
        this.setInheritErrorHandlerFlag(condition);
        return (Type)this;
    }

    public Type process(Processor processor) {
        ProcessorRef answer = new ProcessorRef(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type processRef(String ref) {
        ProcessorRef answer = new ProcessorRef();
        answer.setRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean) {
        BeanRef answer = new BeanRef();
        answer.setBean(bean);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method) {
        BeanRef answer = new BeanRef();
        answer.setBean(bean);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType) {
        BeanRef answer = new BeanRef();
        answer.setBeanType(beanType);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType, String method) {
        BeanRef answer = new BeanRef();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref) {
        BeanRef answer = new BeanRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref, String method) {
        BeanRef answer = new BeanRef(ref, method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type setBody(Expression expression) {
        return this.process(ProcessorBuilder.setBody(expression));
    }

    public Type setOutBody(Expression expression) {
        return this.process(ProcessorBuilder.setOutBody(expression));
    }

    public Type setFaultBody(Expression expression) {
        return this.process(ProcessorBuilder.setFaultBody(expression));
    }

    public Type setHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setHeader(name, expression));
    }

    public Type setOutHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setOutHeader(name, expression));
    }

    public Type setFaultHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setFaultHeader(name, expression));
    }

    public Type setProperty(String name, Expression expression) {
        return this.process(ProcessorBuilder.setProperty(name, expression));
    }

    public Type removeHeader(String name) {
        return this.process(ProcessorBuilder.removeHeader(name));
    }

    public Type removeOutHeader(String name) {
        return this.process(ProcessorBuilder.removeOutHeader(name));
    }

    public Type removeFaultHeader(String name) {
        return this.process(ProcessorBuilder.removeFaultHeader(name));
    }

    public Type removeProperty(String name) {
        return this.process(ProcessorBuilder.removeProperty(name));
    }

    public Type convertBodyTo(Class type) {
        return this.process(ProcessorBuilder.setBody(Builder.body().convertTo(type)));
    }

    public Type convertOutBodyTo(Class type) {
        return this.process(ProcessorBuilder.setOutBody(Builder.outBody().convertTo(type)));
    }

    public Type convertFaultBodyTo(Class type) {
        return this.process(ProcessorBuilder.setFaultBody(Builder.faultBody().convertTo(type)));
    }

    public DataTypeExpression<Type> unmarshal() {
        return new DataTypeExpression(this, DataTypeExpression.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatType dataFormatType) {
        this.addOutput(new UnmarshalType(dataFormatType));
        return (Type)this;
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatType(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        this.addOutput(new UnmarshalType(dataTypeRef));
        return (Type)this;
    }

    public DataTypeExpression<Type> marshal() {
        return new DataTypeExpression(this, DataTypeExpression.Operation.Marshal);
    }

    public Type marshal(DataFormatType dataFormatType) {
        this.addOutput(new MarshalType(dataFormatType));
        return (Type)this;
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatType(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalType(dataTypeRef));
        return (Type)this;
    }

    @XmlTransient
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @XmlTransient
    public boolean isInheritErrorHandler() {
        return ObjectConverter.toBoolean(this.getInheritErrorHandlerFlag());
    }

    @XmlAttribute(name="inheritErrorHandler", required=false)
    public Boolean getInheritErrorHandlerFlag() {
        return this.inheritErrorHandlerFlag;
    }

    public void setInheritErrorHandlerFlag(Boolean inheritErrorHandlerFlag) {
        this.inheritErrorHandlerFlag = inheritErrorHandlerFlag;
    }

    @XmlTransient
    public NodeFactory getNodeFactory() {
        if (this.nodeFactory == null) {
            this.nodeFactory = new NodeFactory();
        }
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public String getLabel() {
        return "";
    }

    protected Processor makeProcessor(RouteContext routeContext) throws Exception {
        Processor processor = this.createProcessor(routeContext);
        return this.wrapProcessor(routeContext, processor);
    }

    protected Processor wrapProcessorInInterceptors(RouteContext routeContext, Processor target) throws Exception {
        if (target == null) {
            throw new RuntimeCamelException("target provided.");
        }
        DelegateProcessor first = null;
        DelegateProcessor last = null;
        ArrayList<InterceptorType> interceptors = new ArrayList<InterceptorType>(routeContext.getRoute().getInterceptors());
        List<InterceptorType> list = this.getInterceptors();
        for (InterceptorType interceptorType : list) {
            if (interceptors.contains(interceptorType)) continue;
            interceptors.add(interceptorType);
        }
        for (InterceptorType interceptorRef : interceptors) {
            DelegateProcessor p = interceptorRef.createInterceptor(routeContext);
            if (first == null) {
                first = p;
            }
            if (last != null) {
                last.setProcessor(p);
            }
            last = p;
        }
        if (last != null) {
            last.setProcessor(target);
        }
        return first == null ? target : first;
    }

    protected Processor wrapInErrorHandler(Processor processor) throws Exception {
        return this.getErrorHandlerBuilder().createErrorHandler(processor);
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        if (this.isInheritErrorHandler()) {
            return new DeadLetterChannelBuilder();
        }
        return new NoErrorHandlerBuilder();
    }

    protected void configureChild(ProcessorType output) {
        output.setNodeFactory(this.getNodeFactory());
    }

    protected void addOutput(ProcessorType processorType) {
        this.configureChild(processorType);
        this.getOutputs().add(processorType);
    }

    protected Processor createCompositeProcessor(List<Processor> list) {
        return new Pipeline(list);
    }

    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorType<?>> outputs) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorType<?> output : outputs) {
            Processor processor = output.createProcessor(routeContext);
            list.add(processor);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(list);
        }
        return processor;
    }

    public ThreadType thread(int coreSize) {
        ThreadType answer = new ThreadType(coreSize);
        this.addOutput(answer);
        return answer;
    }

    public ProcessorType<Type> thread(ThreadPoolExecutor executor) {
        ThreadType answer = new ThreadType(executor);
        this.addOutput(answer);
        return this;
    }
}

