/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RedeliveryPolicyType;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="onException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExceptionType
extends ProcessorType<ProcessorType> {
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="redeliveryPolicy", required=false)
    private RedeliveryPolicyType redeliveryPolicy;
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();
    @XmlTransient
    private List<Class> exceptionClasses;
    @XmlTransient
    private Processor errorHandler;

    public ExceptionType() {
    }

    public ExceptionType(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public ExceptionType(Class exceptionType) {
        this.exceptionClasses = new ArrayList<Class>();
        this.exceptionClasses.add(exceptionType);
    }

    public String toString() {
        return "Exception[ " + this.getExceptionClasses() + " -> " + this.getOutputs() + "]";
    }

    public RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicy parentPolicy) {
        if (this.redeliveryPolicy != null) {
            return this.redeliveryPolicy.createRedeliveryPolicy(parentPolicy);
        }
        if (this.errorHandler != null) {
            RedeliveryPolicy answer = parentPolicy.copy();
            answer.setMaximumRedeliveries(0);
            return answer;
        }
        return parentPolicy;
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        this.errorHandler = routeContext.createProcessor(this);
        ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
        builder.addErrorHandlers(this);
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        return new CatchProcessor(this.getExceptionClasses(), childProcessor);
    }

    public ExceptionType backOffMultiplier(double backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public ExceptionType collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public ExceptionType collisionAvoidancePercent(short collisionAvoidancePercent) {
        this.getOrCreateRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public ExceptionType initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().initialRedeliveryDelay(initialRedeliveryDelay);
        return this;
    }

    public ExceptionType maximumRedeliveries(int maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public ExceptionType useCollisionAvoidance() {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public ExceptionType useExponentialBackOff() {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
    }

    public List<Class> getExceptionClasses() {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = this.createExceptionClasses();
        }
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public RedeliveryPolicyType getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicyType redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    protected RedeliveryPolicyType getOrCreateRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicyType();
        }
        return this.redeliveryPolicy;
    }

    protected List<Class> createExceptionClasses() {
        List<String> list = this.getExceptions();
        ArrayList<Class> answer = new ArrayList<Class>(list.size());
        for (String name : list) {
            Class<?> type = ObjectHelper.loadClass(name, this.getClass().getClassLoader());
            answer.add(type);
        }
        return answer;
    }
}

