/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.InstrumentationLifecycleStrategy;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class InstrumentationAgentImpl
extends ServiceSupport
implements InstrumentationAgent,
CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationAgentImpl.class);
    public static final String SYSTEM_PROPERTY_JMX = "org.apache.camel.jmx";
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 1099;
    private MBeanServer server;
    private CamelContext context;
    private Set<ObjectName> mbeans = new HashSet<ObjectName>();
    private MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler();
    private JMXConnectorServer cs;
    private boolean jmxEnabled = false;
    private String jmxDomainName = null;
    private int jmxConnectorPort = 0;
    private CamelNamingStrategy namingStrategy;

    public InstrumentationAgentImpl() {
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
        this.namingStrategy = new CamelNamingStrategy();
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
        this.jmxEnabled = true;
    }

    public MBeanServer getMBeanServer() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
        return this.server;
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanInfo mbi = null;
            mbi = this.assembler.getMBeanInfo(obj, name.toString());
            RequiredModelMBean mbean = (RequiredModelMBean)this.server.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
            try {
                mbean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException itotex) {
                throw new JMException(itotex.getMessage());
            }
            this.registerMBeanWithServer(mbean, name, forceRegistration);
        }
    }

    public void unregister(ObjectName name) throws JMException {
        this.server.unregisterMBean(name);
    }

    public CamelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(CamelNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.context, "camelContext");
        if (this.getMBeanServer() == null) {
            this.createMBeanServer();
        }
        if (this.jmxDomainName == null) {
            this.jmxDomainName = System.getProperty("org.apache.camel.jmx.domain");
            if (this.jmxDomainName == null || this.jmxDomainName.length() == 0) {
                this.jmxDomainName = DEFAULT_DOMAIN;
            }
        }
        this.configureDomainName();
        LOG.debug("Starting JMX agent on server: " + this.getMBeanServer());
        if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext dc = (DefaultCamelContext)this.context;
            InstrumentationLifecycleStrategy ls = new InstrumentationLifecycleStrategy(this);
            dc.setLifecycleStrategy(ls);
            ls.onContextCreate(this.context);
        }
    }

    protected void doStop() throws Exception {
        Object[] mBeans = this.mbeans.toArray();
        int caught = 0;
        for (Object name : mBeans) {
            this.mbeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.info("Exception unregistering MBean", jmex);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation.  " + "See INFO log for details.");
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.server.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.server.unregisterMBean(name);
                instance = this.server.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.mbeans.add(name);
        }
    }

    public void enableJmx(String domainName, int port) {
        this.jmxEnabled = true;
        this.jmxDomainName = domainName;
        this.configureDomainName();
        this.jmxConnectorPort = port;
    }

    protected void configureDomainName() {
        if (this.jmxDomainName != null) {
            this.namingStrategy.setDomainName(this.jmxDomainName);
        }
    }

    protected void createMBeanServer() {
        String hostName = DEFAULT_HOST;
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            String portKey;
            String portValue;
            if (!this.jmxEnabled) {
                boolean bl = this.jmxEnabled = null != System.getProperty(SYSTEM_PROPERTY_JMX);
                if (!this.jmxEnabled) {
                    return;
                }
            }
            if (this.jmxConnectorPort <= 0 && (portValue = System.getProperty(portKey = "org.apache.camel.jmx.port")) != null && portValue.length() > 0) {
                try {
                    this.jmxConnectorPort = Integer.parseInt(portValue);
                }
                catch (NumberFormatException nfe) {
                    LOG.info("Invalid port number specified via System property [" + portKey + "=" + portValue + "].  Using default: " + 1099);
                    this.jmxConnectorPort = 1099;
                }
            }
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.info("Cannot determine host name.  Using default: 1099", uhe);
                hostName = DEFAULT_HOST;
            }
        } else {
            this.jmxDomainName = this.jmxDomainName != null ? this.jmxDomainName : DEFAULT_DOMAIN;
            this.jmxConnectorPort = this.jmxConnectorPort > 0 ? this.jmxConnectorPort : 1099;
            hostName = DEFAULT_HOST;
        }
        if (!this.jmxEnabled) {
            return;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(this.jmxDomainName);
        this.server = servers.size() == 0 ? MBeanServerFactory.createMBeanServer(this.jmxDomainName) : (MBeanServer)servers.get(0);
        try {
            this.createJmxConnector(hostName);
        }
        catch (IOException ioe) {
            LOG.warn("Could not create and start jmx connector.", ioe);
        }
    }

    protected void createJmxConnector(String host) throws IOException {
        if (this.jmxConnectorPort > 0) {
            try {
                LocateRegistry.createRegistry(this.jmxConnectorPort);
            }
            catch (RemoteException ex) {
                LocateRegistry.getRegistry(this.jmxConnectorPort);
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.jmxConnectorPort + "/jmxrmi");
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
            Thread connectorThread = new Thread(){

                public void run() {
                    try {
                        InstrumentationAgentImpl.this.cs.start();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Could not start jmx connector thread.", ioe);
                    }
                }
            };
            connectorThread.setName("JMX Connector Thread [" + url + "]");
            connectorThread.start();
            LOG.info("Jmx connector thread started on " + url);
        }
    }
}

