/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerEndpoint
extends DefaultEndpoint<Exchange> {
    private final TimerComponent component;
    private final String timerName;
    private Date time;
    private long period = 1000L;
    private long delay = 0L;
    private boolean fixedRate;
    private boolean daemon = true;
    private Timer timer;

    public TimerEndpoint(String fullURI, TimerComponent component, String timerName) {
        super(fullURI, component);
        this.component = component;
        this.timerName = timerName;
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new TimerConsumer(this, processor);
    }

    @Override
    public TimerComponent getComponent() {
        return this.component;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = this.component.getTimer(this);
        }
        return this.timer;
    }
}

