/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.TopicPublisher;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer102;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer102;
import org.springframework.jms.listener.serversession.ServerSessionFactory;
import org.springframework.jms.listener.serversession.ServerSessionMessageListenerContainer;
import org.springframework.jms.listener.serversession.ServerSessionMessageListenerContainer102;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class JmsConfiguration
implements Cloneable {
    protected static final String TRANSACTED = "TRANSACTED";
    protected static final String CLIENT_ACKNOWLEDGE = "CLIENT_ACKNOWLEDGE";
    protected static final String AUTO_ACKNOWLEDGE = "AUTO_ACKNOWLEDGE";
    protected static final String DUPS_OK_ACKNOWLEDGE = "DUPS_OK_ACKNOWLEDGE";
    private JmsOperations jmsOperations;
    private DestinationResolver destinationResolver;
    private ConnectionFactory connectionFactory;
    private ConnectionFactory templateConnectionFactory;
    private ConnectionFactory listenerConnectionFactory;
    private int acknowledgementMode = -1;
    private String acknowledgementModeName = null;
    private ExceptionListener exceptionListener;
    private ConsumerType consumerType = ConsumerType.Default;
    private boolean autoStartup = true;
    private boolean acceptMessagesWhileStopping;
    private String clientId;
    private String durableSubscriptionName;
    private boolean subscriptionDurable;
    private boolean exposeListenerSession = true;
    private TaskExecutor taskExecutor;
    private boolean pubSubNoLocal;
    private int concurrentConsumers = 1;
    private int maxMessagesPerTask = 1;
    private ServerSessionFactory serverSessionFactory;
    private int cacheLevel = -1;
    private String cacheLevelName = "CACHE_CONNECTION";
    private long recoveryInterval = -1L;
    private long receiveTimeout = -1L;
    private int idleTaskExecutionLimit = 1;
    private int maxConcurrentConsumers = 1;
    private boolean useVersion102;
    private boolean explicitQosEnabled;
    private boolean deliveryPersistent = true;
    private long timeToLive = -1L;
    private MessageConverter messageConverter;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private int priority = -1;
    private boolean transacted;
    private PlatformTransactionManager transactionManager;
    private String transactionName;
    private int transactionTimeout = -1;
    private boolean preserveMessageQos;

    public JmsConfiguration() {
    }

    public JmsConfiguration(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsConfiguration copy() {
        try {
            return (JmsConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public JmsOperations createJmsOperations(boolean pubSubDomain, String destination) {
        if (this.jmsOperations != null) {
            return this.jmsOperations;
        }
        ConnectionFactory factory = this.getTemplateConnectionFactory();
        Object template = this.useVersion102 ? new JmsTemplate102(factory, pubSubDomain){

            protected void doSend(MessageProducer producer, Message message) throws JMSException {
                if (JmsConfiguration.this.preserveMessageQos) {
                    long ttl = message.getJMSExpiration();
                    if (ttl != 0L && (ttl -= System.currentTimeMillis()) <= 0L) {
                        ttl = 1L;
                    }
                    if (this.isPubSubDomain()) {
                        ((TopicPublisher)producer).publish(message, message.getJMSDeliveryMode(), message.getJMSPriority(), ttl);
                    } else {
                        ((QueueSender)producer).send(message, message.getJMSDeliveryMode(), message.getJMSPriority(), ttl);
                    }
                } else {
                    super.doSend(producer, message);
                }
            }
        } : new JmsTemplate(factory){

            protected void doSend(MessageProducer producer, Message message) throws JMSException {
                if (JmsConfiguration.this.preserveMessageQos) {
                    long ttl = message.getJMSExpiration();
                    if (ttl != 0L && (ttl -= System.currentTimeMillis()) <= 0L) {
                        ttl = 1L;
                    }
                    producer.send(message, message.getJMSDeliveryMode(), message.getJMSPriority(), ttl);
                } else {
                    super.doSend(producer, message);
                }
            }
        };
        template.setPubSubDomain(pubSubDomain);
        if (this.destinationResolver != null) {
            template.setDestinationResolver(this.destinationResolver);
        }
        template.setDefaultDestinationName(destination);
        template.setExplicitQosEnabled(this.explicitQosEnabled);
        template.setDeliveryPersistent(this.deliveryPersistent);
        if (this.messageConverter != null) {
            template.setMessageConverter(this.messageConverter);
        }
        template.setMessageIdEnabled(this.messageIdEnabled);
        template.setMessageTimestampEnabled(this.messageTimestampEnabled);
        if (this.priority >= 0) {
            template.setPriority(this.priority);
        }
        template.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.receiveTimeout >= 0L) {
            template.setReceiveTimeout(this.receiveTimeout);
        }
        if (this.timeToLive >= 0L) {
            template.setTimeToLive(this.timeToLive);
        }
        template.setSessionTransacted(this.transacted);
        if (this.transacted) {
            template.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            template.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            template.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        return template;
    }

    public AbstractMessageListenerContainer createMessageListenerContainer() {
        AbstractMessageListenerContainer container = this.chooseMessageListenerContainerImplementation();
        this.configureMessageListenerContainer(container);
        return container;
    }

    protected void configureMessageListenerContainer(AbstractMessageListenerContainer container) {
        container.setConnectionFactory(this.getListenerConnectionFactory());
        if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        if (this.autoStartup) {
            container.setAutoStartup(true);
        }
        if (this.clientId != null) {
            container.setClientId(this.clientId);
        }
        container.setSubscriptionDurable(this.subscriptionDurable);
        if (this.durableSubscriptionName != null) {
            container.setDurableSubscriptionName(this.durableSubscriptionName);
        }
        if (this.durableSubscriptionName != null && this.clientId != null) {
            container.setSubscriptionDurable(true);
        }
        if (this.exceptionListener != null) {
            container.setExceptionListener(this.exceptionListener);
        }
        container.setAcceptMessagesWhileStopping(this.acceptMessagesWhileStopping);
        container.setExposeListenerSession(this.exposeListenerSession);
        container.setSessionTransacted(this.transacted);
        if (this.transacted) {
            container.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            container.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            container.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        if (container instanceof DefaultMessageListenerContainer) {
            DefaultMessageListenerContainer listenerContainer = (DefaultMessageListenerContainer)container;
            if (this.concurrentConsumers >= 0) {
                listenerContainer.setConcurrentConsumers(this.concurrentConsumers);
            }
            if (this.cacheLevel >= 0) {
                listenerContainer.setCacheLevel(this.cacheLevel);
            } else if (this.cacheLevelName != null) {
                listenerContainer.setCacheLevelName(this.cacheLevelName);
            } else {
                listenerContainer.setCacheLevel(3);
            }
            if (this.idleTaskExecutionLimit >= 0) {
                listenerContainer.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit);
            }
            if (this.maxConcurrentConsumers >= 0) {
                listenerContainer.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
            }
            if (this.maxMessagesPerTask >= 0) {
                listenerContainer.setMaxMessagesPerTask(this.maxMessagesPerTask);
            }
            listenerContainer.setPubSubNoLocal(this.pubSubNoLocal);
            if (this.receiveTimeout >= 0L) {
                listenerContainer.setReceiveTimeout(this.receiveTimeout);
            }
            if (this.recoveryInterval >= 0L) {
                listenerContainer.setRecoveryInterval(this.recoveryInterval);
            }
            if (this.taskExecutor != null) {
                listenerContainer.setTaskExecutor(this.taskExecutor);
            }
            if (this.transactionManager != null) {
                listenerContainer.setTransactionManager(this.transactionManager);
            } else if (this.transacted) {
                throw new IllegalArgumentException("Property transacted is enabled but a transactionManager was not injected!");
            }
            if (this.transactionName != null) {
                listenerContainer.setTransactionName(this.transactionName);
            }
            if (this.transactionTimeout >= 0) {
                listenerContainer.setTransactionTimeout(this.transactionTimeout);
            }
        } else if (container instanceof ServerSessionMessageListenerContainer) {
            ServerSessionMessageListenerContainer listenerContainer = (ServerSessionMessageListenerContainer)container;
            if (this.maxMessagesPerTask >= 0) {
                listenerContainer.setMaxMessagesPerTask(this.maxMessagesPerTask);
            }
            if (this.serverSessionFactory != null) {
                listenerContainer.setServerSessionFactory(this.serverSessionFactory);
            }
        } else if (container instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer listenerContainer = (SimpleMessageListenerContainer)container;
            if (this.concurrentConsumers >= 0) {
                listenerContainer.setConcurrentConsumers(this.concurrentConsumers);
            }
            listenerContainer.setPubSubNoLocal(this.pubSubNoLocal);
            if (this.taskExecutor != null) {
                listenerContainer.setTaskExecutor(this.taskExecutor);
            }
        }
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getListenerConnectionFactory() {
        if (this.listenerConnectionFactory == null) {
            this.listenerConnectionFactory = this.createListenerConnectionFactory();
        }
        return this.listenerConnectionFactory;
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.listenerConnectionFactory = listenerConnectionFactory;
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        if (this.templateConnectionFactory == null) {
            this.templateConnectionFactory = this.createTemplateConnectionFactory();
        }
        return this.templateConnectionFactory;
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.templateConnectionFactory = templateConnectionFactory;
    }

    public boolean isUseVersion102() {
        return this.useVersion102;
    }

    public void setUseVersion102(boolean useVersion102) {
        this.useVersion102 = useVersion102;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.acceptMessagesWhileStopping;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String consumerClientId) {
        this.clientId = consumerClientId;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getAcknowledgementModeName() {
        return this.acknowledgementModeName;
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.acknowledgementModeName = consumerAcknowledgementMode;
        this.acknowledgementMode = -1;
    }

    public boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public ServerSessionFactory getServerSessionFactory() {
        return this.serverSessionFactory;
    }

    public void setServerSessionFactory(ServerSessionFactory serverSessionFactory) {
        this.serverSessionFactory = serverSessionFactory;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheLevelName() {
        return this.cacheLevelName;
    }

    public void setCacheLevelName(String cacheName) {
        this.cacheLevelName = cacheName;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isDeliveryPersistent() {
        return this.deliveryPersistent;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryPersistent = deliveryPersistent;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ConsumerType getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.consumerType = consumerType;
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.acknowledgementMode = consumerAcknowledgementMode;
        this.acknowledgementModeName = null;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean consumerTransacted) {
        this.transacted = consumerTransacted;
    }

    protected AbstractMessageListenerContainer chooseMessageListenerContainerImplementation() {
        switch (this.consumerType) {
            case Simple: {
                return this.isUseVersion102() ? new SimpleMessageListenerContainer102() : new SimpleMessageListenerContainer();
            }
            case ServerSessionPool: {
                return this.isUseVersion102() ? new ServerSessionMessageListenerContainer102() : new ServerSessionMessageListenerContainer();
            }
            case Default: {
                return this.isUseVersion102() ? new DefaultMessageListenerContainer102() : new DefaultMessageListenerContainer();
            }
        }
        throw new IllegalArgumentException("Unknown consumer type: " + (Object)((Object)this.consumerType));
    }

    protected ConnectionFactory createConnectionFactory() {
        ObjectHelper.notNull(this.connectionFactory, "connectionFactory");
        return null;
    }

    protected ConnectionFactory createListenerConnectionFactory() {
        return this.getConnectionFactory();
    }

    protected ConnectionFactory createTemplateConnectionFactory() {
        return this.getConnectionFactory();
    }

    public boolean isPreserveMessageQos() {
        return this.preserveMessageQos;
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.preserveMessageQos = preserveMessageQos;
    }

    public JmsOperations getJmsOperations() {
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }
}

