/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.component.file.strategy.FileRenamer;

public class DefaultFileRenamer
implements FileRenamer {
    private static final boolean ON_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private String namePrefix;
    private String namePostfix;

    public DefaultFileRenamer() {
    }

    public DefaultFileRenamer(String namePrefix, String namePostfix) {
        this.namePrefix = namePrefix;
        this.namePostfix = namePostfix;
    }

    public File renameFile(File file) {
        File parent = file.getParentFile();
        String name = this.renameFileName(file);
        if (ON_WINDOWS && (name.indexOf(":") >= 0 || name.startsWith("//"))) {
            return new File(name);
        }
        return new File(parent, name);
    }

    public String getNamePostfix() {
        return this.namePostfix;
    }

    public void setNamePostfix(String namePostfix) {
        this.namePostfix = namePostfix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected String renameFileName(File file) {
        StringBuffer buffer = new StringBuffer();
        if (this.namePrefix != null) {
            buffer.append(this.namePrefix);
        }
        buffer.append(file.getName());
        if (this.namePostfix != null) {
            buffer.append(this.namePostfix);
        }
        return buffer.toString();
    }
}

