/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEndpoint<E extends Exchange>
extends DefaultEndpoint<E> {
    private static final Log LOG = LogFactory.getLog(DirectEndpoint.class);
    boolean allowMultipleConsumers = true;
    private final CopyOnWriteArrayList<DefaultConsumer<E>> consumers = new CopyOnWriteArrayList();

    public DirectEndpoint(String uri, DirectComponent<E> component) {
        super(uri, component);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DirectProducer(this);
    }

    @Override
    public Consumer<E> createConsumer(Processor processor) throws Exception {
        return new DefaultConsumer<E>(this, processor){

            @Override
            public void start() throws Exception {
                if (!DirectEndpoint.this.allowMultipleConsumers && !DirectEndpoint.this.consumers.isEmpty()) {
                    throw new IllegalStateException("Endpoint " + DirectEndpoint.this.getEndpointUri() + " only allows 1 active consumer but you attempted to start a 2nd consumer.");
                }
                DirectEndpoint.this.consumers.add(this);
                super.start();
            }

            @Override
            public void stop() throws Exception {
                super.stop();
                DirectEndpoint.this.consumers.remove(this);
            }
        };
    }

    public boolean isAllowMultipleConsumers() {
        return this.allowMultipleConsumers;
    }

    public void setAllowMultipleConsumers(boolean allowMutlipleConsumers) {
        this.allowMultipleConsumers = allowMutlipleConsumers;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private final class DirectProducer
    extends DefaultProducer
    implements AsyncProcessor {
        private DirectProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
            if (DirectEndpoint.this.consumers.isEmpty()) {
                LOG.warn("No consumers available on " + this + " for " + exchange);
            } else {
                for (DefaultConsumer consumer : DirectEndpoint.this.consumers) {
                    consumer.getProcessor().process(exchange);
                }
            }
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            int size = DirectEndpoint.this.consumers.size();
            if (size == 0) {
                LOG.warn("No consumers available on " + this + " for " + exchange);
            } else if (size > 1) {
                try {
                    for (DefaultConsumer consumer : DirectEndpoint.this.consumers) {
                        consumer.getProcessor().process(exchange);
                    }
                }
                catch (Throwable error) {
                    exchange.setException(error);
                }
            } else {
                Iterator i$ = DirectEndpoint.this.consumers.iterator();
                if (i$.hasNext()) {
                    DefaultConsumer consumer = (DefaultConsumer)i$.next();
                    AsyncProcessor processor = AsyncProcessorTypeConverter.convert(consumer.getProcessor());
                    return processor.process(exchange, callback);
                }
            }
            callback.done(true);
            return true;
        }
    }
}

