/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.interceptors.RawMessageContentRedirectInterceptor;
import org.apache.camel.component.cxf.interceptors.RawMessageInInterceptor;
import org.apache.camel.component.cxf.invoker.AbstractInvokingContext;
import org.apache.camel.component.cxf.phase.RawMessagePhaseManagerImpl;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawMessageInvokingContext
extends AbstractInvokingContext {
    private static final Logger LOG = Logger.getLogger(RawMessageInvokingContext.class.getName());
    private PhaseManager phaseManager = new RawMessagePhaseManagerImpl();

    @Override
    public PhaseInterceptorChain getRequestOutInterceptorChain(Exchange exchange) {
        return this.getOutInterceptorChain(exchange);
    }

    @Override
    public PhaseInterceptorChain getResponseOutInterceptorChain(Exchange exchange) {
        return this.getOutInterceptorChain(exchange);
    }

    private PhaseInterceptorChain getOutInterceptorChain(Exchange exchange) {
        PhaseInterceptorChain chain = new PhaseInterceptorChain(new RawMessagePhaseManagerImpl().getOutPhases());
        Bus bus = (Bus)exchange.get(Bus.class);
        assert (bus != null);
        List list = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + list);
        }
        chain.add((Collection)list);
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        if (endpoint != null) {
            list = endpoint.getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by endpoint: " + list);
            }
            chain.add((Collection)list);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("inject " + RawMessageContentRedirectInterceptor.class);
        }
        chain.add((Interceptor)new RawMessageContentRedirectInterceptor());
        return chain;
    }

    @Override
    public void setRequestOutMessageContent(Message message, Object content) {
        message.setContent(InputStream.class, content);
    }

    @Override
    protected SortedSet<Phase> getInPhases() {
        return this.phaseManager.getInPhases();
    }

    @Override
    protected List<Interceptor> getRoutingInterceptors() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add((Interceptor)new RawMessageInInterceptor());
        return list;
    }

    @Override
    public Object getResponseObject(Exchange exchange, Map<String, Object> responseContext) {
        return this.getResponseObject(exchange.getInMessage(), responseContext, InputStream.class);
    }

    @Override
    protected PhaseInterceptorChain getInInterceptorChain(Exchange exchange, boolean isResponse) {
        Bus bus = (Bus)exchange.get(Bus.class);
        assert (bus != null);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.getInPhases());
        if (!isResponse) {
            List<Interceptor> routingInterceptors = this.getRoutingInterceptors();
            chain.add(routingInterceptors);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Injected " + routingInterceptors);
            }
        }
        List list = bus.getInInterceptors();
        LOG.fine("Interceptors contributed by bus: " + list);
        chain.add((Collection)list);
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        if (ep != null) {
            list = ep.getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by endpoint: " + list);
            }
            chain.add((Collection)list);
        }
        return chain;
    }

    @Override
    public void setResponseContent(Message outMessage, Object resultPayload) {
        LOG.info("Set content: " + resultPayload);
        outMessage.setContent(InputStream.class, resultPayload);
    }

    @Override
    public Object getRequestContent(Message inMessage) {
        return inMessage.getContent(InputStream.class);
    }

    private void loggerTheMessage(Message message, String messageTile) {
        StringBuffer buffer = new StringBuffer(messageTile + "\n" + "--------------------------------------");
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                is.close();
                bos.close();
                buffer.append("\nMessage:\n");
                buffer.append(bos.getOut().toString());
                message.setContent(InputStream.class, (Object)bos.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        buffer.append("\n--------------------------------------");
        LOG.info(buffer.toString());
    }
}

