/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.CamelInvoker;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ROUTING_INERCEPTOR_PHASE = "Routing-Phase";
    public static final String BUNDLE = "wsdl-cxf";

    public AbstractInvokerInterceptor(String phase) {
        super(phase);
    }

    private boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }

    public void handleMessage(Message inMessage) throws Fault {
        if (this.isRequestor(inMessage)) {
            return;
        }
        Exchange exchange = inMessage.getExchange();
        Message outMessage = null;
        try {
            CamelInvoker invoker = (CamelInvoker)exchange.get(CamelInvoker.class);
            outMessage = invoker.invoke(inMessage);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.setBackChannelConduit(exchange, outMessage);
        Exception ex = (Exception)outMessage.getContent(Exception.class);
        if (ex != null) {
            if (!(ex instanceof Fault)) {
                ex = new Fault((Throwable)ex);
            }
            throw (Fault)ex;
        }
        outMessage.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (boi != null) {
            exchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
        InvokingContext invokingContext = (InvokingContext)exchange.get(InvokingContext.class);
        assert (invokingContext != null);
        PhaseInterceptorChain chain = invokingContext.getResponseOutInterceptorChain(exchange);
        if (chain != null) {
            outMessage.setInterceptorChain((InterceptorChain)chain);
            chain.doIntercept(outMessage);
        }
    }

    protected void setBackChannelConduit(Exchange ex, Message message) throws Fault {
        Conduit conduit = ex.getConduit(message);
        if (conduit == null) {
            try {
                EndpointReferenceType target = (EndpointReferenceType)ex.get(EndpointReferenceType.class);
                conduit = ex.getDestination().getBackChannel(ex.getInMessage(), null, target);
                ex.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(conduit));
            }
            catch (IOException e) {
                throw new Fault((Throwable)e);
            }
        }
        assert (conduit != null);
    }

    protected abstract Logger getLogger();
}

