/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.AsyncProcessorDecorator;
import org.apache.camel.component.cxf.CxfSoapEndpoint;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CxfSoapProducer
implements Producer,
AsyncProcessor {
    private static final Log LOG = LogFactory.getLog(CxfSoapProducer.class);
    private final CxfSoapEndpoint endpoint;
    private final Producer producer;
    private final AsyncProcessor processor;

    public CxfSoapProducer(CxfSoapEndpoint endpoint) throws Exception {
        this.endpoint = endpoint;
        this.producer = endpoint.getInnerEndpoint().createProducer();
        this.processor = new AsyncProcessorDecorator(this.producer, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapProducer.this.processSoapProviderIn(exchange);
            }
        }, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapProducer.this.processSoapProviderOut(exchange);
            }
        });
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    public void start() throws Exception {
        this.producer.start();
    }

    public void stop() throws Exception {
        this.producer.stop();
    }

    protected void processSoapProviderIn(Exchange exchange) throws Exception {
        LOG.info("processSoapProviderIn: " + exchange);
    }

    protected void processSoapProviderOut(Exchange exchange) throws Exception {
        LOG.info("processSoapProviderOut: " + exchange);
    }
}

