/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.impl.DefaultExchange;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;

public class CxfExchange
extends DefaultExchange {
    private final CxfBinding binding;
    private Exchange exchange;

    public CxfExchange(CamelContext context, CxfBinding binding, Exchange exchange) {
        super(context);
        this.binding = binding;
        this.exchange = exchange;
        this.setIn(new CxfMessage(exchange.getInMessage()));
        this.setOut(new CxfMessage(exchange.getOutMessage()));
        if (exchange.getInFaultMessage() != null) {
            this.setFault(new CxfMessage(exchange.getInFaultMessage()));
        }
    }

    public CxfExchange(CamelContext context, ExchangePattern pattern, CxfBinding binding) {
        super(context, pattern);
        this.binding = binding;
    }

    public CxfExchange(CamelContext context, ExchangePattern pattern, CxfBinding binding, org.apache.cxf.message.Message inMessage) {
        this(context, pattern, binding);
        this.exchange = inMessage.getExchange();
        this.setIn(new CxfMessage(inMessage));
        if (this.exchange != null) {
            this.setOut(new CxfMessage(this.exchange.getOutMessage()));
            if (this.exchange.getInFaultMessage() != null) {
                this.setFault(new CxfMessage(this.exchange.getInFaultMessage()));
            }
        }
    }

    public CxfMessage getIn() {
        return (CxfMessage)super.getIn();
    }

    public CxfMessage getOut() {
        return (CxfMessage)super.getOut();
    }

    public CxfMessage getOut(boolean lazyCreate) {
        return (CxfMessage)super.getOut(lazyCreate);
    }

    public CxfMessage getFault() {
        return (CxfMessage)super.getFault();
    }

    protected Message createFaultMessage() {
        return new CxfMessage();
    }

    public CxfBinding getBinding() {
        return this.binding;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public org.apache.cxf.message.Message getInMessage() {
        return this.getIn().getMessage();
    }

    public org.apache.cxf.message.Message getOutMessage() {
        return this.getOut().getMessage();
    }

    public org.apache.cxf.message.Message getOutFaultMessage() {
        return this.getExchange().getOutFaultMessage();
    }

    public org.apache.cxf.message.Message getInFaultMessage() {
        return this.getExchange().getInFaultMessage();
    }

    public Destination getDestination() {
        return this.getExchange().getDestination();
    }

    public Conduit getConduit(org.apache.cxf.message.Message message) {
        return this.getExchange().getConduit(message);
    }

    protected CxfMessage createInMessage() {
        return new CxfMessage();
    }

    protected CxfMessage createOutMessage() {
        return new CxfMessage();
    }
}

