/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadLetterChannel
extends ErrorHandlerSupport {
    public static final String REDELIVERY_COUNTER = "org.apache.camel.RedeliveryCounter";
    public static final String REDELIVERED = "org.apache.camel.Redelivered";
    private static final transient Log LOG = LogFactory.getLog(DeadLetterChannel.class);
    private Processor output;
    private Processor deadLetter;
    private RedeliveryPolicy redeliveryPolicy;
    private Logger logger;

    public DeadLetterChannel(Processor output, Processor deadLetter) {
        this(output, deadLetter, new RedeliveryPolicy(), DeadLetterChannel.createDefaultLogger());
    }

    public DeadLetterChannel(Processor output, Processor deadLetter, RedeliveryPolicy redeliveryPolicy, Logger logger) {
        this.deadLetter = deadLetter;
        this.output = output;
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
    }

    public static <E extends Exchange> Logger createDefaultLogger() {
        return new Logger(LOG, LoggingLevel.ERROR);
    }

    public String toString() {
        return "DeadLetterChannel[" + this.output + ", " + this.deadLetter + ", " + this.redeliveryPolicy + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        int redeliveryCounter = 0;
        long redeliveryDelay = 0L;
        RedeliveryPolicy currentRedeliveryPolicy = this.redeliveryPolicy;
        Processor failureProcessor = this.deadLetter;
        while (true) {
            if (redeliveryCounter > 0) {
                redeliveryDelay = currentRedeliveryPolicy.getRedeliveryDelay(redeliveryDelay);
                this.sleep(redeliveryDelay);
            }
            try {
                this.output.process(exchange);
                return;
            }
            catch (Throwable e) {
                this.logger.log("On delivery attempt: " + redeliveryCounter + " caught: " + e, e);
                redeliveryCounter = this.incrementRedeliveryCounter(exchange, e);
                ExceptionType exceptionPolicy = this.getExceptionPolicy(exchange, e);
                if (exceptionPolicy == null) continue;
                currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(currentRedeliveryPolicy);
                Processor processor = exceptionPolicy.getErrorHandler();
                if (processor == null) continue;
                failureProcessor = processor;
                if (currentRedeliveryPolicy.shouldRedeliver(redeliveryCounter)) continue;
                failureProcessor.process(exchange);
                return;
            }
            break;
        }
    }

    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected int incrementRedeliveryCounter(Exchange exchange, Throwable e) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader(REDELIVERY_COUNTER, Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader(REDELIVERY_COUNTER, next);
        in.setHeader(REDELIVERED, true);
        exchange.setException(e);
        return next;
    }

    protected void sleep(long redeliveryDelay) {
        block4: {
            if (redeliveryDelay > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sleeping for: " + redeliveryDelay + " until attempting redelivery");
                }
                try {
                    Thread.sleep(redeliveryDelay);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Thread interupted: " + e, e);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.deadLetter);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.deadLetter, this.output);
    }
}

