/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.OutputType;

@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanRef
extends OutputType {
    @XmlAttribute(required=true)
    private String ref;
    @XmlAttribute(required=false)
    private String method;
    @XmlTransient
    private Object bean;

    public BeanRef() {
    }

    public BeanRef(Object bean) {
        this.bean = bean;
    }

    public BeanRef(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.description() + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Processor createProcessor(RouteContext routeContext) {
        if (this.bean == null) {
            this.bean = routeContext.lookup(this.getRef(), Object.class);
        }
        BeanProcessor answer = new BeanProcessor(this.bean, routeContext.getCamelContext());
        if (this.method != null) {
            answer.setMethodName(this.method);
        }
        return answer;
    }

    protected String description() {
        if (this.bean != null) {
            return this.bean.toString();
        }
        String methodText = "";
        if (this.method != null) {
            methodText = " method: " + this.method;
        }
        return "ref: " + this.ref + methodText;
    }
}

