/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultPollingConsumer;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultEndpoint<E extends Exchange>
implements Endpoint<E> {
    private String endpointUri;
    private CamelContext context;
    private Component component;
    private ScheduledExecutorService executorService;

    protected DefaultEndpoint(String endpointUri, Component component) {
        this(endpointUri, component.getCamelContext());
        this.component = component;
    }

    protected DefaultEndpoint(String endpointUri, CamelContext context) {
        this.endpointUri = endpointUri;
        this.context = context;
    }

    public int hashCode() {
        return this.endpointUri.hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)object;
            return ObjectHelper.equals(this.endpointUri, that.endpointUri);
        }
        return false;
    }

    public String toString() {
        return "Endpoint[" + this.endpointUri + "]";
    }

    @Override
    public String getEndpointUri() {
        return this.endpointUri;
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    public Component getComponent() {
        return this.component;
    }

    public synchronized ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            Component c = this.getComponent();
            if (c != null && c instanceof DefaultComponent) {
                DefaultComponent dc = (DefaultComponent)c;
                this.executorService = dc.getExecutorService();
            }
            if (this.executorService == null) {
                this.executorService = this.createExecutorService();
            }
        }
        return this.executorService;
    }

    public synchronized void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public PollingConsumer<E> createPollingConsumer() throws Exception {
        return new DefaultPollingConsumer(this);
    }

    public E convertTo(Class<E> type, Exchange exchange) {
        if (type.isInstance(exchange)) {
            return (E)((Exchange)type.cast(exchange));
        }
        return (E)((Exchange)this.getContext().getExchangeConverter().convertTo(type, exchange));
    }

    @Override
    public E createExchange(Exchange exchange) {
        Class<E> exchangeType = this.getExchangeType();
        if (exchangeType != null && exchangeType.isInstance(exchange)) {
            return (E)((Exchange)exchangeType.cast(exchange));
        }
        Object answer = this.createExchange();
        answer.copyFrom(exchange);
        return answer;
    }

    @Override
    public E toExchangeType(Exchange exchange) {
        return this.createExchange(exchange);
    }

    public Class<E> getExchangeType() {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    protected ScheduledThreadPoolExecutor createExecutorService() {
        return new ScheduledThreadPoolExecutor(10);
    }
}

