/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(FileProducer.class);
    private final FileEndpoint endpoint;

    public FileProducer(FileEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        this.process((FileExchange)this.endpoint.toExchangeType(exchange));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FileExchange exchange) throws Exception {
        InputStream in = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        File file = this.createFileName(exchange);
        this.buildDirectory(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to write to: " + file + " from exchange: " + exchange);
        }
        AbstractInterruptibleChannel fc = null;
        try {
            int count;
            if (this.getEndpoint().isAppend()) {
                fc = new RandomAccessFile(file, "rw").getChannel();
                ((FileChannel)fc).position(((FileChannel)fc).size());
            } else {
                fc = new FileOutputStream(file).getChannel();
            }
            int size = this.getEndpoint().getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((count = in.read(buffer)) > 0) {
                if (count < size) {
                    byteBuffer = ByteBuffer.wrap(buffer, 0, count);
                    ((FileChannel)fc).write(byteBuffer);
                    break;
                }
                ((FileChannel)fc).write(byteBuffer);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close input: " + e, e);
                }
            }
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close output: " + e, e);
                }
            }
        }
    }

    protected File createFileName(FileExchange exchange) {
        String fileName = exchange.getIn().getMessageId();
        File endpointFile = this.endpoint.getFile();
        String name = exchange.getIn().getHeader("org.apache.camel.file.name", String.class);
        if (name != null) {
            File answer = new File(endpointFile, name);
            if (answer.isDirectory()) {
                return new File(answer, fileName);
            }
            return answer;
        }
        if (endpointFile != null && endpointFile.isDirectory()) {
            return new File(endpointFile, fileName);
        }
        return new File(fileName);
    }

    private void buildDirectory(File file) {
        String dirName = file.getAbsolutePath();
        int index = dirName.lastIndexOf(File.separatorChar);
        if (index > 0) {
            dirName = dirName.substring(0, index);
            File dir = new File(dirName);
            dir.mkdirs();
        }
    }
}

