/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ProducerCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelTemplate<E extends Exchange>
extends ServiceSupport
implements ProducerTemplate<E> {
    private CamelContext context;
    private ProducerCache<E> producerCache = new ProducerCache();
    private boolean useEndpointCache = true;
    private Map<String, Endpoint<E>> endpointCache = new HashMap<String, Endpoint<E>>();
    private Endpoint<E> defaultEndpoint;

    public CamelTemplate(CamelContext context) {
        this.context = context;
    }

    public CamelTemplate(CamelContext context, Endpoint defaultEndpoint) {
        this(context);
        this.defaultEndpoint = defaultEndpoint;
    }

    @Override
    public E send(String endpointUri, E exchange) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        this.send(endpoint, exchange);
        return exchange;
    }

    @Override
    public E send(String endpointUri, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, processor);
    }

    @Override
    public E send(Endpoint<E> endpoint, E exchange) {
        E convertedExchange = endpoint.toExchangeType((Exchange)exchange);
        this.producerCache.send(endpoint, convertedExchange);
        return exchange;
    }

    @Override
    public E send(Endpoint<E> endpoint, Processor processor) {
        return this.producerCache.send(endpoint, processor);
    }

    @Override
    public Object sendBody(Endpoint<E> endpoint, final Object body) {
        E result = this.send(endpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        });
        return this.extractResultBody(result);
    }

    @Override
    public Object sendBody(String endpointUri, final Object body) {
        E result = this.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        });
        return this.extractResultBody(result);
    }

    public Object sendBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    public Object sendBodyAndHeader(Endpoint endpoint, final Object body, final String header, final Object headerValue) {
        E result = this.send(endpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader(header, headerValue);
                in.setBody(body);
            }
        });
        return this.extractResultBody(result);
    }

    public Object sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    public Object sendBodyAndHeaders(Endpoint endpoint, final Object body, final Map<String, Object> headers) {
        E result = this.send(endpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                for (Map.Entry header : headers.entrySet()) {
                    in.setHeader((String)header.getKey(), header.getValue());
                }
                in.setBody(body);
            }
        });
        return this.extractResultBody(result);
    }

    @Override
    public Object sendBody(Object body) {
        return this.sendBody(this.getMandatoryDefaultEndpoint(), body);
    }

    @Override
    public E send(E exchange) {
        return this.send(this.getMandatoryDefaultEndpoint(), exchange);
    }

    @Override
    public E send(Processor processor) {
        return this.send(this.getMandatoryDefaultEndpoint(), processor);
    }

    @Override
    public Object sendBodyAndHeader(Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), body, header, headerValue);
    }

    @Override
    public Object sendBodyAndHeaders(Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), body, headers);
    }

    public Producer<E> getProducer(Endpoint<E> endpoint) {
        return this.producerCache.getProducer(endpoint);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Endpoint<E> getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(Endpoint<E> defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getContext().getEndpoint(endpointUri));
    }

    public boolean isUseEndpointCache() {
        return this.useEndpointCache;
    }

    public void setUseEndpointCache(boolean useEndpointCache) {
        this.useEndpointCache = useEndpointCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        Endpoint endpoint = null;
        if (this.isUseEndpointCache()) {
            Map<String, Endpoint<E>> map = this.endpointCache;
            synchronized (map) {
                endpoint = this.endpointCache.get(endpointUri);
                if (endpoint == null && (endpoint = this.context.getEndpoint(endpointUri)) != null) {
                    this.endpointCache.put(endpointUri, endpoint);
                }
            }
        } else {
            endpoint = this.context.getEndpoint(endpointUri);
        }
        if (endpoint == null) {
            throw new NoSuchEndpointException(endpointUri);
        }
        return endpoint;
    }

    protected Endpoint<E> getMandatoryDefaultEndpoint() {
        Endpoint<E> answer = this.getDefaultEndpoint();
        ObjectHelper.notNull(answer, "defaultEndpoint");
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        this.producerCache.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.producerCache.stop();
    }

    protected Object extractResultBody(E result) {
        Object answer = null;
        if (result != null && (answer = result.getOut().getBody()) == null) {
            answer = result.getIn().getBody();
        }
        return answer;
    }
}

