/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerCache<E extends Exchange>
extends ServiceSupport {
    private static final Log log = LogFactory.getLog(ProducerCache.class);
    private Map<String, Producer<E>> producers = new HashMap<String, Producer<E>>();

    public synchronized Producer<E> getProducer(Endpoint<E> endpoint) {
        String key = endpoint.getEndpointUri();
        Producer<E> answer = this.producers.get(key);
        if (answer == null) {
            try {
                answer = endpoint.createProducer();
                answer.start();
            }
            catch (Exception e) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)e);
            }
            this.producers.put(key, answer);
        }
        return answer;
    }

    public void send(Endpoint<E> endpoint, E exchange) {
        try {
            Producer<E> producer = this.getProducer(endpoint);
            producer.process((Exchange)exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public E send(Endpoint<E> endpoint, Processor processor) {
        try {
            Producer<E> producer = this.getProducer(endpoint);
            E exchange = producer.createExchange();
            processor.process((Exchange)exchange);
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>>> " + endpoint + " " + exchange));
            }
            producer.process((Exchange)exchange);
            return exchange;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producers.values());
    }

    @Override
    protected void doStart() throws Exception {
    }
}

