/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class SpringComponentResolver
implements ComponentResolver {
    private final ApplicationContext applicationContext;
    private final ComponentResolver nextResolver;

    public SpringComponentResolver(ApplicationContext applicationContext, ComponentResolver nextResolver) {
        ObjectHelper.notNull(applicationContext, "applicationContext");
        this.applicationContext = applicationContext;
        this.nextResolver = nextResolver;
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean = null;
        try {
            bean = this.applicationContext.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            // empty catch block
        }
        if (bean != null) {
            if (bean instanceof Component) {
                return (Component)bean;
            }
            throw new IllegalArgumentException("Bean with name: " + name + " in spring context is not a Component: " + bean);
        }
        if (this.nextResolver == null) {
            return null;
        }
        return this.nextResolver.resolveComponent(name, context);
    }
}

