/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.processor.idempotent.NoMessageIdException;
import org.apache.camel.util.ExpressionHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdempotentConsumer
extends ServiceSupport
implements Processor {
    private static final transient Log log = LogFactory.getLog(IdempotentConsumer.class);
    private Expression<Exchange> messageIdExpression;
    private Processor nextProcessor;
    private MessageIdRepository messageIdRepository;

    public IdempotentConsumer(Expression<Exchange> messageIdExpression, MessageIdRepository messageIdRepository, Processor nextProcessor) {
        this.messageIdExpression = messageIdExpression;
        this.messageIdRepository = messageIdRepository;
        this.nextProcessor = nextProcessor;
    }

    public String toString() {
        return "IdempotentConsumer[expression=" + this.messageIdExpression + ", repository=" + this.messageIdRepository + ", processor=" + this.nextProcessor + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String messageId = ExpressionHelper.evaluateAsString(this.messageIdExpression, exchange);
        if (messageId == null) {
            throw new NoMessageIdException(exchange, this.messageIdExpression);
        }
        if (!this.messageIdRepository.contains(messageId)) {
            this.nextProcessor.process(exchange);
        } else {
            this.onDuplicateMessage(exchange, messageId);
        }
    }

    public Expression<Exchange> getMessageIdExpression() {
        return this.messageIdExpression;
    }

    public MessageIdRepository getMessageIdRepository() {
        return this.messageIdRepository;
    }

    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.nextProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.nextProcessor);
    }

    protected void onDuplicateMessage(Exchange exchange, String messageId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring duplicate message with id: " + messageId + " for exchange: " + exchange));
        }
    }
}

