/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.processor.MulticastProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements Processor {
    public Pipeline(Collection<Endpoint> endpoints) throws Exception {
        super(endpoints);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange nextExchange = exchange;
        boolean first = true;
        for (Producer producer : this.getProducers()) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(producer, nextExchange);
            }
            producer.process(nextExchange);
        }
    }

    protected Exchange createNextExchange(Producer producer, Exchange previousExchange) {
        Exchange answer = producer.createExchange(previousExchange);
        Object output = previousExchange.getOut().getBody();
        if (output != null) {
            answer.getIn().setBody(output);
        }
        return answer;
    }

    protected Exchange copyExchangeStrategy(Exchange exchange) {
        return exchange.copy();
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getEndpoints();
    }
}

