/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterProcessor
extends ServiceSupport
implements Processor {
    private Predicate<Exchange> predicate;
    private Processor processor;

    public FilterProcessor(Predicate<Exchange> predicate, Processor processor) {
        this.predicate = predicate;
        this.processor = processor;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.predicate.matches(exchange)) {
            this.processor.process(exchange);
        }
    }

    public String toString() {
        return "filter (" + this.predicate + ") " + this.processor;
    }

    public Predicate<Exchange> getPredicate() {
        return this.predicate;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }
}

