/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.processor;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.processor.ProcessorEndpointConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorEndpoint
extends DefaultEndpoint<Exchange> {
    private final Processor processor;
    private final LoadBalancer loadBalancer;

    protected ProcessorEndpoint(String endpointUri, Component component, Processor processor, LoadBalancer loadBalancer) {
        super(endpointUri, component);
        this.processor = processor;
        this.loadBalancer = loadBalancer;
    }

    @Override
    public Exchange createExchange() {
        return new DefaultExchange(this.getContext());
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ProcessorEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new ProcessorEndpointConsumer(this, processor);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.processor.process(exchange);
        this.loadBalancer.process(exchange);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

