/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.pojo.PojoEndpoint;
import org.apache.camel.component.pojo.PojoExchange;
import org.apache.camel.component.pojo.PojoInvocation;
import org.apache.camel.impl.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoComponent
extends DefaultComponent<PojoExchange> {
    protected final HashMap<String, Object> services = new HashMap();

    public void addService(String uri, Object pojo) {
        this.services.put(uri, pojo);
    }

    public void removeService(String uri) {
        this.services.remove(uri);
    }

    public Object getService(String uri) {
        return this.services.get(uri);
    }

    @Override
    protected Endpoint<PojoExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        Object pojo = this.getService(remaining);
        return new PojoEndpoint(uri, this, pojo);
    }

    public static Object createProxy(final Endpoint endpoint, ClassLoader cl, Class[] interfaces) throws Exception {
        final Producer producer = endpoint.createProducer();
        return Proxy.newProxyInstance(cl, interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                PojoInvocation invocation = new PojoInvocation(proxy, method, args);
                PojoExchange exchange = new PojoExchange(endpoint.getContext());
                exchange.setInvocation(invocation);
                producer.process(exchange);
                Throwable fault = exchange.getException();
                if (fault != null) {
                    throw new InvocationTargetException(fault);
                }
                return exchange.getOut().getBody();
            }
        });
    }

    public static Object createProxy(Endpoint endpoint, Class[] interfaces) throws Exception {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("You must provide at least 1 interface class.");
        }
        return PojoComponent.createProxy(endpoint, interfaces[0].getClassLoader(), interfaces);
    }

    public static <T> T createProxy(Endpoint endpoint, ClassLoader cl, Class<T> interfaceClass) throws Exception {
        return (T)PojoComponent.createProxy(endpoint, cl, new Class[]{interfaceClass});
    }

    public static <T> T createProxy(Endpoint endpoint, Class<T> interfaceClass) throws Exception {
        return (T)PojoComponent.createProxy(endpoint, new Class[]{interfaceClass});
    }
}

