/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Processor;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaConsumer
extends DefaultConsumer<MinaExchange> {
    private static final transient Log log = LogFactory.getLog(MinaConsumer.class);
    private final MinaEndpoint endpoint;
    private final SocketAddress address;
    private final IoAcceptor acceptor;

    public MinaConsumer(MinaEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.address = endpoint.getAddress();
        this.acceptor = endpoint.getAcceptor();
    }

    @Override
    protected void doStart() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding to server address: " + this.address + " using acceptor: " + this.acceptor));
        }
        IoHandlerAdapter handler = new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object object) throws Exception {
                MinaConsumer.this.getProcessor().process(MinaConsumer.this.endpoint.createExchange(session, object));
            }
        };
        this.acceptor.bind(this.address, (IoHandler)handler, this.endpoint.getConfig());
    }

    @Override
    protected void doStop() throws Exception {
        this.acceptor.unbind(this.address);
        super.doStop();
    }
}

