/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jbi.CamelJbiComponent;
import org.apache.camel.component.jbi.CamelJbiEndpoint;
import org.apache.camel.component.jbi.JbiBinding;
import org.apache.camel.component.jbi.JbiExchange;
import org.apache.camel.component.jbi.ToJbiProcessor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiEndpoint
extends DefaultEndpoint<Exchange> {
    private Processor toJbiProcessor;
    private final CamelJbiComponent jbiComponent;

    public JbiEndpoint(CamelJbiComponent jbiComponent, String uri) {
        super(uri, jbiComponent);
        this.jbiComponent = jbiComponent;
        this.toJbiProcessor = new ToJbiProcessor(jbiComponent.getBinding(), jbiComponent.getComponentContext(), uri);
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) throws Exception {
                JbiEndpoint.this.toJbiProcessor.process(exchange);
            }
        };
    }

    @Override
    public Consumer<Exchange> createConsumer(final Processor processor) throws Exception {
        return new DefaultConsumer<Exchange>((Endpoint)this, processor){
            CamelJbiEndpoint jbiEndpoint;

            @Override
            protected void doStart() throws Exception {
                super.doStart();
                this.jbiEndpoint = JbiEndpoint.this.jbiComponent.activateJbiEndpoint(JbiEndpoint.this, processor);
            }

            @Override
            protected void doStop() throws Exception {
                super.doStop();
            }
        };
    }

    @Override
    public JbiExchange createExchange() {
        return new JbiExchange(this.getContext(), this.getBinding());
    }

    public JbiBinding getBinding() {
        return this.jbiComponent.getBinding();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

