/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jbi.CamelJbiEndpoint;
import org.apache.camel.component.jbi.JbiBinding;
import org.apache.camel.component.jbi.JbiEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.IntrospectionSupport;
import org.apache.servicemix.jbi.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelJbiComponent
extends DefaultComponent
implements Component<Exchange> {
    private JbiBinding binding;
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;

    protected List<CamelJbiEndpoint> getConfiguredEndpoints() {
        ArrayList<CamelJbiEndpoint> answer = new ArrayList<CamelJbiEndpoint>();
        return answer;
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{CamelJbiEndpoint.class};
    }

    public JbiBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JbiBinding();
        }
        return this.binding;
    }

    public void setBinding(JbiBinding binding) {
        this.binding = binding;
    }

    protected String[] getEPRProtocols() {
        return new String[]{"camel"};
    }

    protected org.apache.servicemix.common.Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        CamelJbiEndpoint endpoint = this.createEndpoint(ep);
        endpoint.activate();
        return endpoint;
    }

    public CamelJbiEndpoint createEndpoint(ServiceEndpoint ep) throws URISyntaxException {
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        String camelUri = uri.getSchemeSpecificPart();
        Endpoint camelEndpoint = this.getCamelContext().getEndpoint(camelUri);
        Producer processor = null;
        try {
            processor = camelEndpoint.createProducer();
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(camelEndpoint, (Throwable)e);
        }
        CamelJbiEndpoint endpoint = new CamelJbiEndpoint(this.getServiceUnit(), camelEndpoint, this.getBinding(), processor);
        IntrospectionSupport.setProperties((Object)((Object)endpoint), (Map)map);
        return endpoint;
    }

    @Override
    public Endpoint<Exchange> createEndpoint(String uri) {
        if (uri.startsWith("jbi:")) {
            uri = uri.substring("jbi:".length());
            return new JbiEndpoint(this, uri);
        }
        return null;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ScheduledThreadPoolExecutor(5);
        }
        return this.executorService;
    }

    public CamelJbiEndpoint activateJbiEndpoint(JbiEndpoint camelEndpoint, Processor processor) throws Exception {
        CamelJbiEndpoint jbiEndpoint;
        String endpointUri = camelEndpoint.getEndpointUri();
        if (endpointUri.startsWith("endpoint:")) {
            String uri = endpointUri.substring("endpoint:".length());
            String[] parts = new String[]{};
            try {
                parts = URIResolver.split3((String)uri);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Expected syntax endpoint:[serviceNamespace]:[serviceName]:[endpointName] but was given: " + endpointUri + ". Cause: " + e, e);
            }
            QName service = new QName(parts[0], parts[1]);
            String endpoint = parts[2];
            jbiEndpoint = new CamelJbiEndpoint(this.getServiceUnit(), service, endpoint, camelEndpoint, this.getBinding(), processor);
        } else {
            jbiEndpoint = new CamelJbiEndpoint(this.getServiceUnit(), camelEndpoint, this.getBinding(), processor);
        }
        this.addEndpoint((org.apache.servicemix.common.Endpoint)jbiEndpoint);
        return jbiEndpoint;
    }
}

