/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfInvokeEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfInvokeComponent
extends DefaultComponent<CxfExchange> {
    private Bus bus = CXFBusFactory.getDefaultBus();

    public CxfInvokeComponent() {
    }

    public CxfInvokeComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint<CxfExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        return new CxfInvokeEndpoint(this.getAddress(remaining), this, this.getQueryAsProperties(new URI(remaining)));
    }

    protected Properties getQueryAsProperties(URI u) {
        Properties retval = new Properties();
        if (u.getQuery() != null) {
            String[] parameters = u.getQuery().split("&");
            for (int i = 0; i < parameters.length; ++i) {
                String[] s = parameters[i].split("=");
                retval.put(s[0], s[1]);
            }
        }
        return retval;
    }

    protected String getAddress(String uri) {
        int index = uri.indexOf("?");
        if (-1 != index) {
            return uri.substring(0, index);
        }
        return uri;
    }

    public Bus getBus() {
        return this.bus;
    }
}

