/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.impl.DefaultCamelContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RouteBuilder
extends BuilderSupport {
    private List<FromBuilder> fromBuilders = new ArrayList<FromBuilder>();
    private AtomicBoolean initalized = new AtomicBoolean(false);
    private List<Route> routes = new ArrayList<Route>();

    protected RouteBuilder() {
        this((CamelContext)null);
    }

    protected RouteBuilder(CamelContext context) {
        super(context);
    }

    public abstract void configure() throws Exception;

    @Fluent
    public FromBuilder from(@FluentArg(value="uri") String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri parameter cannot be null");
        }
        Endpoint endpoint = this.endpoint(uri);
        if (endpoint == null) {
            throw new IllegalArgumentException("uri '" + uri + "' could not be resolved.");
        }
        return this.from(endpoint);
    }

    @Fluent
    public FromBuilder from(@FluentArg(value="ref") Endpoint endpoint) {
        FromBuilder answer = new FromBuilder(this, endpoint);
        this.addFromBuilder(answer);
        return answer;
    }

    public RouteBuilder errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return this;
    }

    public RouteBuilder inheritErrorHandler(boolean value) {
        this.setInheritErrorHandler(value);
        return this;
    }

    @Override
    public CamelContext getContext() {
        CamelContext context = super.getContext();
        if (context == null) {
            context = this.createContainer();
            this.setContext(context);
        }
        return context;
    }

    public List<Route> getRouteList() throws Exception {
        this.checkInitialized();
        return this.routes;
    }

    public List<FromBuilder> getFromBuilders() throws Exception {
        this.checkInitialized();
        return this.fromBuilders;
    }

    public void addFromBuilder(FromBuilder answer) {
        this.fromBuilders.add(answer);
    }

    protected void checkInitialized() throws Exception {
        if (this.initalized.compareAndSet(false, true)) {
            this.configure();
            this.populateRoutes(this.routes);
        }
    }

    protected void populateRoutes(List<Route> routes) throws Exception {
        for (FromBuilder builder : this.fromBuilders) {
            Route route = builder.createRoute();
            routes.add(route);
        }
    }

    protected CamelContext createContainer() {
        return new DefaultCamelContext();
    }
}

