/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.splunk.search.SplunkConnection;
import org.apache.calcite.adapter.splunk.util.StringUtils;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SplunkQuery<T>
extends AbstractEnumerable<T> {
    private final SplunkConnection splunkConnection;
    private final String search;
    private final @Nullable String earliest;
    private final @Nullable String latest;
    private final @Nullable List<String> fieldList;

    public SplunkQuery(SplunkConnection splunkConnection, String search, @Nullable String earliest, @Nullable String latest, @Nullable List<String> fieldList) {
        this.splunkConnection = Objects.requireNonNull(splunkConnection, "splunkConnection");
        this.search = Objects.requireNonNull(search, "search");
        this.earliest = earliest;
        this.latest = latest;
        this.fieldList = fieldList;
    }

    public String toString() {
        return "SplunkQuery {" + this.search + "}";
    }

    public Enumerator<T> enumerator() {
        return this.splunkConnection.getSearchResultEnumerator(this.search, this.getArgs(), this.fieldList);
    }

    private Map<String, String> getArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.fieldList != null) {
            String fields = StringUtils.encodeList(this.fieldList, ',').toString();
            args.put("field_list", fields);
        }
        if (this.earliest != null) {
            args.put("earliest_time", this.earliest);
        }
        if (this.latest != null) {
            args.put("latest_time", this.latest);
        }
        return args;
    }
}

