/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

public enum RedisDataType {
    STRING("string"),
    HASH("hash"),
    LIST("list"),
    SET("set"),
    SORTED_SET("zset"),
    HYPER_LOG_LOG("pfadd"),
    PUBSUB("publish");

    private final String typeName;

    private RedisDataType(String typeName) {
        this.typeName = typeName;
    }

    public static RedisDataType fromTypeName(String typeName) {
        for (RedisDataType type : RedisDataType.values()) {
            if (!type.getTypeName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

