/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.redis.RedisConfig;
import org.apache.calcite.adapter.redis.RedisDataFormat;
import org.apache.calcite.adapter.redis.RedisDataProcess;
import org.apache.calcite.adapter.redis.RedisJedisManager;
import org.apache.calcite.adapter.redis.RedisSchema;
import org.apache.calcite.adapter.redis.RedisTableFieldInfo;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

class RedisEnumerator
implements Enumerator<Object[]> {
    private final Enumerator<Object[]> enumerator;

    RedisEnumerator(RedisConfig redisConfig, RedisSchema schema, String tableName) {
        RedisTableFieldInfo tableFieldInfo = schema.getTableFieldInfo(tableName);
        RedisJedisManager redisManager = new RedisJedisManager(redisConfig.getHost(), redisConfig.getPort(), redisConfig.getDatabase(), redisConfig.getPassword());
        try (Jedis jedis = redisManager.getResource();){
            if (StringUtils.isNotEmpty((CharSequence)redisConfig.getPassword())) {
                jedis.auth(redisConfig.getPassword());
            }
            RedisDataProcess dataProcess = new RedisDataProcess(jedis, tableFieldInfo);
            List<Object[]> objs = dataProcess.read();
            this.enumerator = Linq4j.enumerator(objs);
        }
    }

    static Map<String, Object> deduceRowType(RedisTableFieldInfo tableFieldInfo) {
        LinkedHashMap<String, Object> fieldBuilder = new LinkedHashMap<String, Object>();
        String dataFormat = tableFieldInfo.getDataFormat();
        RedisDataFormat redisDataFormat = Objects.requireNonNull(RedisDataFormat.fromTypeName(dataFormat));
        if (redisDataFormat == RedisDataFormat.RAW) {
            fieldBuilder.put("key", "key");
        } else {
            for (LinkedHashMap<String, Object> field : tableFieldInfo.getFields()) {
                fieldBuilder.put(field.get("name").toString(), field.get("type").toString());
            }
        }
        return fieldBuilder;
    }

    public Object[] current() {
        return (Object[])this.enumerator.current();
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        this.enumerator.close();
    }
}

