/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.redis.RedisDataFormat;
import org.apache.calcite.adapter.redis.RedisDataType;
import org.apache.calcite.adapter.redis.RedisTableFieldInfo;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

public class RedisDataProcess {
    final String tableName;
    final String dataFormat;
    final String keyDelimiter;
    final RedisDataType dataType;
    final RedisDataFormat redisDataFormat;
    final List<LinkedHashMap<String, Object>> fields;
    private final Jedis jedis;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RedisDataProcess(Jedis jedis, RedisTableFieldInfo tableFieldInfo) {
        this.jedis = jedis;
        String type = jedis.type(tableFieldInfo.getTableName());
        this.fields = tableFieldInfo.getFields();
        this.dataFormat = tableFieldInfo.getDataFormat();
        this.tableName = tableFieldInfo.getTableName();
        this.keyDelimiter = tableFieldInfo.getKeyDelimiter();
        this.dataType = Objects.requireNonNull(RedisDataType.fromTypeName(type));
        this.redisDataFormat = Objects.requireNonNull(RedisDataFormat.fromTypeName(tableFieldInfo.getDataFormat()));
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    public List<Object[]> read() {
        switch (this.dataType) {
            case STRING: {
                return this.parse(this.jedis.keys(this.tableName));
            }
            case LIST: {
                return this.parse(this.jedis.lrange(this.tableName, 0L, -1L));
            }
            case SET: {
                return this.parse(this.jedis.smembers(this.tableName));
            }
            case SORTED_SET: {
                return this.parse(this.jedis.zrange(this.tableName, 0L, -1L));
            }
            case HASH: {
                return this.parse(this.jedis.hvals(this.tableName));
            }
        }
        return new ArrayList<Object[]>();
    }

    private Object[] parseJson(String value) {
        assert (StringUtils.isNotEmpty((CharSequence)value));
        Object[] arr = new Object[this.fields.size()];
        try {
            JsonNode jsonNode = this.objectMapper.readTree(value);
            for (int i = 0; i < arr.length; ++i) {
                Object obj = this.fields.get(i).get("mapping");
                arr[i] = obj == null ? "" : jsonNode.findValue(this.fields.get(i).get("mapping").toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing json failed: ", e);
        }
        return arr;
    }

    private Object[] parseCsv(String value) {
        assert (StringUtils.isNotEmpty((CharSequence)value));
        String[] values = value.split(this.keyDelimiter);
        Object[] arr = new Object[this.fields.size()];
        assert (values.length == arr.length);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = values[i] == null ? "" : values[i];
        }
        return arr;
    }

    List<Object[]> parse(Iterable<String> keys) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        for (String key : keys) {
            if (this.dataType == RedisDataType.STRING) {
                key = this.jedis.get(key);
            }
            switch (this.redisDataFormat) {
                case RAW: {
                    objects.add(new Object[]{key});
                    break;
                }
                case JSON: {
                    objects.add(this.parseJson(key));
                    break;
                }
                case CSV: {
                    objects.add(this.parseCsv(key));
                    break;
                }
            }
        }
        return objects;
    }

    public List<Object[]> parse(List<String> keys) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        for (String key : keys) {
            if (this.dataType == RedisDataType.STRING) {
                key = this.jedis.get(key);
            }
            switch (this.redisDataFormat) {
                case RAW: {
                    objects.add(new Object[]{key});
                    break;
                }
                case JSON: {
                    objects.add(this.parseJson(key));
                    break;
                }
                case CSV: {
                    objects.add(this.parseCsv(key));
                    break;
                }
            }
        }
        return objects;
    }
}

