/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.redis;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.redis.RedisConfig;
import org.apache.calcite.adapter.redis.RedisEnumerator;
import org.apache.calcite.adapter.redis.RedisSchema;
import org.apache.calcite.adapter.redis.RedisTableFieldInfo;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RedisTable
extends AbstractTable
implements ScannableTable {
    final RedisSchema schema;
    final String tableName;
    final RelProtoDataType protoRowType;
    final ImmutableMap<String, Object> allFields;
    final String dataFormat;
    final RedisConfig redisConfig;
    RedisEnumerator redisEnumerator;

    public RedisTable(RedisSchema schema, String tableName, RelProtoDataType protoRowType, Map<String, Object> allFields, String dataFormat, RedisConfig redisConfig) {
        this.schema = schema;
        this.tableName = tableName;
        this.protoRowType = protoRowType;
        this.allFields = allFields == null ? ImmutableMap.of() : ImmutableMap.copyOf(allFields);
        this.dataFormat = dataFormat;
        this.redisConfig = redisConfig;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>(this.allFields.size());
        ArrayList<String> names = new ArrayList<String>(this.allFields.size());
        for (Object key : this.allFields.keySet()) {
            RelDataType type = typeFactory.createJavaType(this.allFields.get(key).getClass());
            names.add(key.toString());
            types.add(type);
        }
        return typeFactory.createStructType(Pair.zip(names, types));
    }

    static Table create(RedisSchema schema, String tableName, RedisConfig redisConfig, RelProtoDataType protoRowType) {
        RedisTableFieldInfo tableFieldInfo = schema.getTableFieldInfo(tableName);
        Map<String, Object> allFields = RedisEnumerator.deduceRowType(tableFieldInfo);
        return new RedisTable(schema, tableName, protoRowType, allFields, tableFieldInfo.getDataFormat(), redisConfig);
    }

    static Table create(RedisSchema schema, String tableName, Map operand, RelProtoDataType protoRowType) {
        RedisConfig redisConfig = new RedisConfig(schema.host, schema.port, schema.database, schema.password);
        return RedisTable.create(schema, tableName, redisConfig, protoRowType);
    }

    public Enumerable<@Nullable Object[]> scan(DataContext root) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new RedisEnumerator(RedisTable.this.redisConfig, RedisTable.this.schema, RedisTable.this.tableName);
            }
        };
    }
}

